/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine;

import java.io.FileNotFoundException;
import org.gcube.application.geoportal.common.model.legacy.WorkspaceContent;
import org.gcube.application.geoportal.common.utils.Files;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.engine.WorkspaceManager;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkspaceManager {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceManager.class);
    private static final Object $LOCK = new Object[0];
    private static final String APP_FOLDER = ".GNA_RECORDS";
    private StorageHubClient sgClient = ImplementationProvider.get().getSHubProvider().getObject();
    private FolderContainer appBase = WorkspaceManager.getApplicationBaseFolder((StorageHubClient)this.sgClient);

    public FolderContainer createFolder(FolderOptions opts) throws StorageHubException {
        if (opts.getParent() == null) {
            opts.setParent(this.appBase);
        }
        return WorkspaceManager.createFolder((FolderOptions)opts, (StorageHubClient)this.sgClient);
    }

    public FileContainer getFileById(String id) throws StorageHubException {
        return this.sgClient.open(id).asFile();
    }

    public FolderContainer getFolderById(String id) throws StorageHubException {
        return this.sgClient.open(id).asFolder();
    }

    public void removeFolderById(String id) throws StorageHubException {
        this.sgClient.open(id).asFolder().delete();
    }

    public FolderContainer getSubFolder(FolderContainer parentFolder, String path) throws StorageHubException {
        try {
            return parentFolder.openByRelativePath(path).asFolder();
        }
        catch (StorageHubException e) {
            log.debug("Missing subPath " + path);
            FolderContainer targetParent = parentFolder;
            String targetName = path;
            if (path.contains("/")) {
                String parent = path.substring(0, path.lastIndexOf("/"));
                log.debug("Checking intermediate " + parent);
                targetParent = this.getSubFolder(parentFolder, parent);
                targetName = path.substring(path.lastIndexOf("/") + 1);
            }
            log.debug("Creating " + targetName);
            return WorkspaceManager.createFolder((FolderOptions)new FolderOptions(targetName, "", targetParent), (StorageHubClient)this.sgClient);
        }
    }

    public WorkspaceContent storeToWS(FileOptions opts) throws FileNotFoundException, StorageHubException {
        FileContainer item = WorkspaceManager.createFile((FileOptions)opts, (StorageHubClient)this.sgClient);
        item = this.sgClient.open(item.getId()).asFile();
        WorkspaceContent content = new WorkspaceContent();
        content.setLink(item.getPublicLink().toString());
        content.setMimetype(((AbstractFileItem)item.get()).getContent().getMimeType());
        content.setStorageID(item.getId());
        return content;
    }

    public void deleteFromWS(WorkspaceContent toDelete) throws StorageHubException {
        this.sgClient.open(toDelete.getStorageID()).asFile().forceDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderContainer getApplicationBaseFolder(StorageHubClient sgClient) throws StorageHubException {
        Object object = $LOCK;
        synchronized (object) {
            FolderContainer vre = sgClient.openVREFolder();
            try {
                return vre.openByRelativePath(".GNA_RECORDS").asFolder();
            }
            catch (StorageHubException e) {
                log.debug("APP Fodler missing. Initializing..");
                FolderContainer toReturn = vre.newFolder(".GNA_RECORDS", "Base folder for GNA records");
                toReturn.setHidden();
                return toReturn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FolderContainer createFolder(FolderOptions opts, StorageHubClient sgClient) throws StorageHubException {
        Object object = $LOCK;
        synchronized (object) {
            opts.setFolderName(Files.fixFilename((String)opts.getFolderName()));
            return opts.getParent().newFolder(opts.getFolderName(), opts.getFolderDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileContainer createFile(FileOptions opts, StorageHubClient sgClient) throws StorageHubException {
        Object object = $LOCK;
        synchronized (object) {
            opts.setFileName(Files.fixFilename((String)opts.getFileName()));
            return opts.getParent().uploadFile(opts.getIs(), opts.getFileName(), opts.getFileDescription());
        }
    }
}

