/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class Serialization {
    public static final DateTimeFormatter FULL_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMdd_HH-mm-ss");
    public static ObjectMapper mapper = new ObjectMapper();

    public static <T> T read(String jsonString, Class<T> clazz) throws JsonProcessingException, IOException {
        return (T)mapper.readerFor(clazz).readValue(jsonString);
    }

    public static <T> Iterator<T> readCollection(String jsonString, Class<T> clazz) throws IOException {
        return mapper.readerFor(clazz).readValues(jsonString);
    }

    public static String write(Object toWrite) throws JsonProcessingException {
        String toReturn = mapper.writeValueAsString(toWrite);
        return toReturn;
    }

    public static QueryRequest parseQuery(String queryString) throws IOException {
        Document queryDocument = Document.parse((String)queryString);
        QueryRequest req = new QueryRequest();
        if (queryDocument.containsKey((Object)"ordering")) {
            req.setOrdering((QueryRequest.OrderedRequest)Serialization.read((String)((Document)queryDocument.get((Object)"ordering")).toJson(), QueryRequest.OrderedRequest.class));
        }
        if (queryDocument.containsKey((Object)"paging")) {
            req.setPaging((QueryRequest.PagedRequest)Serialization.read((String)((Document)queryDocument.get((Object)"paging")).toJson(), QueryRequest.PagedRequest.class));
        }
        req.setProjection((Document)queryDocument.get((Object)"projection", Document.class));
        req.setFilter((Document)queryDocument.get((Object)"filter", Document.class));
        return req;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

