package org.gcube.application.geoportal.service.engine.providers;

import lombok.extern.slf4j.Slf4j;
import org.gcube.application.geoportal.common.rest.InterfaceConstants;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.application.geoportal.service.utils.ContextUtils;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.transfer.library.utils.Utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
@Slf4j
public class StorageClientProvider extends AbstractScopedMap<StorageUtils> {

	
	
	public StorageClientProvider() {
		super("Storage client cache");
//		setTTL(Duration.of(10, ChronoUnit.MINUTES));
	}
	
	@Override
	protected StorageUtils retrieveObject() throws ConfigurationException {
		return new StorageUtils();
//		return new StorageClient(InterfaceConstants.SERVICE_CLASS, InterfaceConstants.SERVICE_NAME, ContextUtils.getCurrentCaller(), AccessType.SHARED, MemoryType.VOLATILE).getClient();
	}
	
	@Override
	protected void dispose(StorageUtils toDispose) {
		try {
			toDispose.forceClose();
		}catch (NullPointerException e) {
			// expected if closed without uploading
		}catch(Throwable t) {
			log.warn(" unable to dispose "+toDispose,t); 
		}
	}

	@Override
	public void init() {
		
	}
	
}
