package org.gcube.application.geoportal.service.rest;

import lombok.extern.slf4j.Slf4j;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;
import java.util.ArrayList;
import java.util.List;

@Slf4j
public abstract class GuardedMethod<T> {

	private static List<Runnable> preoperations=new ArrayList<>();

	public static void addPreoperation(Runnable preoperation){
		preoperations.add(preoperation);
	}




	private T result=null;
	
	public GuardedMethod<T> execute() throws WebApplicationException{
		try {
			if(!preoperations.isEmpty()) {
				log.debug("Running preops (size : {} )", preoperations.size());
				for (Runnable r : preoperations)
					r.run();
			}
			log.debug("Executing actual method..");
			result=run();
			return this;
		}catch(WebApplicationException e) {
			throw e;
		}catch(Throwable t) {
			log.error("Unexpected error ",t);
			throw new WebApplicationException("Unexpected internal error", t,Status.INTERNAL_SERVER_ERROR);
		}
		
	}
	
	public T getResult() {
		return result;
	}
	
	
	protected abstract T run() throws Exception,WebApplicationException;
}
