/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import org.bson.Document;
import org.gcube.application.cms.plugins.faults.EventException;
import org.gcube.application.cms.plugins.faults.InsufficientPrivileges;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.geoportal.common.faults.StorageException;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.common.model.rest.RegisterFileSetRequest;
import org.gcube.application.geoportal.service.model.internal.faults.DeletionException;
import org.gcube.application.geoportal.service.model.internal.faults.InvalidLockException;
import org.gcube.application.geoportal.service.model.internal.faults.InvalidUserRoleException;
import org.gcube.application.geoportal.service.model.internal.faults.ProjectLockedException;
import org.gcube.application.geoportal.service.model.internal.faults.ProjectNotFoundException;
import org.gcube.application.geoportal.service.model.internal.faults.RegistrationException;
import org.gcube.application.geoportal.service.model.internal.faults.UnauthorizedAccess;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;

public interface MongoManagerI<T> {
    public T registerNew(Document var1) throws IOException, StepException, EventException, InvalidUserRoleException;

    public T update(String var1, Document var2) throws IOException, StepException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess;

    public T setRelation(String var1, String var2, String var3, String var4) throws IOException, StepException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess, RegistrationException, ConfigurationException;

    public T deleteRelation(String var1, String var2, String var3, String var4) throws IOException, StepException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess, RegistrationException, ConfigurationException;

    public void delete(String var1, boolean var2) throws DeletionException, InvalidUserRoleException, ProjectLockedException, ProjectNotFoundException, UnauthorizedAccess, JsonProcessingException, InvalidLockException;

    public T getByID(String var1) throws IOException, ProjectNotFoundException, InvalidUserRoleException, UnauthorizedAccess;

    public Iterable<Document> query(QueryRequest var1) throws InvalidUserRoleException;

    public Iterable<T> filter(QueryRequest var1) throws InvalidUserRoleException;

    public T performStep(String var1, String var2, Document var3) throws IOException, StepException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess, ConfigurationException, InsufficientPrivileges;

    public T registerFileSet(String var1, RegisterFileSetRequest var2) throws ConfigurationException, StorageHubException, StorageException, StepException, JsonProcessingException, DeletionException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess;

    public T deleteFileSet(String var1, String var2, Boolean var3) throws ConfigurationException, StorageHubException, StorageException, StepException, JsonProcessingException, DeletionException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess;

    public Configuration getConfiguration() throws ConfigurationException;
}

