package org.gcube.application.geoportal.service.engine.providers;

import org.gcube.application.geoportal.service.engine.postgis.PostgisDBManager;
import org.gcube.application.geoportal.service.engine.postgis.PostgisDBManagerI;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;

import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class PostgisConnectionProvider extends AbstractScopedMap<PostgisDBManagerI>{


    public PostgisConnectionProvider() {
        super("Postgis connection descriptor cache");
        setTTL(Duration.of(30, ChronoUnit.SECONDS));
    }

    @Override
    protected PostgisDBManagerI retrieveObject() throws ConfigurationException {
        try {
            return PostgisDBManager.get();
        } catch (SQLException throwables) {
            throw new ConfigurationException(throwables);
        }
    }

    @Override
    protected void dispose(PostgisDBManagerI toDispose) {
//        toDispose.close();
    }

    @Override
    public void init() {
//
    }
}
