package org.gcube.application.geoportal.service.rest;

import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.ProfiledDocument;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.rest.Configuration;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.common.rest.InterfaceConstants;
import org.gcube.application.geoportal.service.engine.mongo.ConcessioniMongoManager;
import org.gcube.application.geoportal.service.engine.mongo.ProfiledMongoManager;
import org.gcube.application.geoportal.service.engine.postgis.PostgisIndex;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.application.geoportal.service.utils.Serialization;
import org.json.JSONArray;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Path(InterfaceConstants.Methods.PROJECTS+"/{"+InterfaceConstants.Parameters.PROFILE_ID+"}")
@Slf4j
public class ProfiledDocuments {

    private ProfiledMongoManager manager;

    public ProfiledDocuments(@PathParam(InterfaceConstants.Parameters.PROFILE_ID) String profileID) throws ConfigurationException {
        log.debug("Accessing profiles "+profileID);
        manager=new GuardedMethod<ProfiledMongoManager>(){
            @Override
            protected ProfiledMongoManager run() throws Exception {
                return new ProfiledMongoManager(profileID);
            }
        }.execute().getResult();
    }

    @GET
    @Path(InterfaceConstants.Methods.CONFIGURATION_PATH)
    @Produces(MediaType.APPLICATION_JSON)
    public Configuration getConfiguration(){
        return new GuardedMethod<Configuration>(){

            @Override
            protected Configuration run() throws Exception, WebApplicationException {
                //manager.getConfiguration();
                throw new Exception("Implement This Method");
            }
        }.execute().getResult();
    }


    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public ProfiledDocument createNew(Document d) {
        return new GuardedMethod<ProfiledDocument>() {
            @Override
            protected ProfiledDocument run() throws Exception, WebApplicationException {
                return manager.registerNew(d);
            }
        }.execute().getResult();
    }

    //********************************** READ

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public Iterable<?> list() {
        return new GuardedMethod<Iterable<?>>() {
            protected Iterable<?> run() throws Exception ,WebApplicationException {
                return manager.query(new QueryRequest());
            };
        }.execute().getResult();
    }

    // BY ID
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("{"+InterfaceConstants.Parameters.PROJECT_ID+"}")
    public ProfiledDocument getById(@PathParam(InterfaceConstants.Parameters.PROJECT_ID) String id) {
        return new GuardedMethod<ProfiledDocument>() {
            @Override
            protected ProfiledDocument run() throws Exception, WebApplicationException {
                return manager.getByID(id);
            }
        }.execute().getResult();
    }


    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/"+InterfaceConstants.Methods.SEARCH_PATH)
    public String search(String filter){
        return new GuardedMethod<String>() {
            @Override
            protected String run() throws Exception, WebApplicationException {
                QueryRequest req=new QueryRequest();
                req.setFilter(Document.parse(filter));
                return Serialization.write(manager.query(req));
            }
        }.execute().getResult();
    }

    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/"+InterfaceConstants.Methods.QUERY_PATH)
    public Iterable<?> query(String queryString){
        return new GuardedMethod<Iterable<?>>() {
            @Override
            protected Iterable<?> run() throws Exception, WebApplicationException {
                return manager.query(Serialization.parseQuery(queryString));
            }
        }.execute().getResult();
    }


}
