/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.RegisterFileSetRequest;
import org.gcube.application.geoportal.common.model.rest.StepExecutionRequest;
import org.gcube.application.geoportal.service.engine.mongo.ProfiledMongoManager;
import org.gcube.application.geoportal.service.http.PATCH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="projects/{usecase_id}")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class ProfiledDocuments {
    private static final Logger log = LoggerFactory.getLogger(ProfiledDocuments.class);
    private ProfiledMongoManager manager;

    public ProfiledDocuments(@PathParam(value="usecase_id") String profileID) throws ConfigurationException {
        log.info("Accessing profile " + profileID);
        this.manager = (ProfiledMongoManager)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Path(value="configuration")
    @Produces(value={"application/json"})
    public Configuration getConfiguration(@PathParam(value="usecase_id") String profileID) {
        return (Configuration)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Project createNew(Document d) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Path(value="{project_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Project update(@PathParam(value="project_id") String documentId, Document d) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PATCH
    @Path(value="{project_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Project patch(@PathParam(value="project_id") String documentId, Document d) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{project_id}")
    public Boolean delete(@PathParam(value="project_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force) {
        return (Boolean)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/registerFiles/{project_id}")
    public Project registerFileSet(@PathParam(value="project_id") String id, RegisterFileSetRequest request) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @RequestHeaders(value={@RequestHeader(name="Authorization", description="VRE Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/deleteFiles/{project_id}")
    public Project deleteFileSet(@PathParam(value="project_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force, @DefaultValue(value="false") @QueryParam(value="ignore_errors") Boolean ignore_errors, String path) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/step/{project_id}")
    public Project performStep(@PathParam(value="project_id") String id, StepExecutionRequest request) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/forceUnlock/{project_id}")
    public Project forceUnlock(@PathParam(value="project_id") String id) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/setAccess/{project_id}")
    public Project setAccessPolicy(@PathParam(value="project_id") String id, Access toSet) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<?> list() {
        return (Iterable)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{project_id}")
    public Project getById(@PathParam(value="project_id") String id) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/search")
    public String search(String filter) {
        return (String)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/query")
    public Iterable<?> query(String queryString) {
        return (Iterable)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public String getRelationshipChain(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @DefaultValue(value="false") @QueryParam(value="deep") Boolean deep) {
        return (String)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public Project setRelation(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @QueryParam(value="target_id") String targetId, @QueryParam(value="target_ucd") String targetUCD) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public Project deleteRelation(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @QueryParam(value="target_id") String targetId, @QueryParam(value="target_ucd") String targetUCD) {
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    static /* synthetic */ ProfiledMongoManager access$000(ProfiledDocuments x0) {
        return x0.manager;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

