/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.gcube.application.geoportal.service.rest.health.DatabaseHealthCheck;
import org.gcube.application.geoportal.service.rest.health.GeoportalHealthCheck;
import org.gcube.application.geoportal.service.rest.health.HealthCheckResponseSerializer;
import org.gcube.application.geoportal.service.rest.health.MongoHealthCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/health")
public class GeoportalHealth {
    private static final Logger log = LoggerFactory.getLogger(GeoportalHealth.class);
    private ObjectMapper mapper = new ObjectMapper();

    public GeoportalHealth() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(HealthCheckResponse.class, (JsonSerializer)new HealthCheckResponseSerializer());
        this.mapper.registerModule((Module)module);
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public Response serviceCheck() throws JsonProcessingException {
        log.debug("serviceCheck called");
        HealthCheckResponse response = new GeoportalHealthCheck().call();
        String json = this.healthCheckSerializer(response);
        log.info("serviceCheck response is {}", (Object)json);
        return Response.ok().entity((Object)json).build();
    }

    @GET
    @Path(value="/mongo")
    @Produces(value={"application/json"})
    public Response mongoCheck(@QueryParam(value="context") String context, @QueryParam(value="include_collections") Boolean includeCollections) throws JsonProcessingException {
        log.debug("mongoCheck called in the context {}", (Object)context);
        if (context == null) {
            HealthCheckResponse response = HealthCheckResponse.named((String)"mongo").withData("context", "is required parameter (e.g. context=/gcube/devsec/devVRE)").down().build();
            String json = this.healthCheckSerializer(response);
            log.info("mongoCheck error response is {}", (Object)json);
            return Response.status((int)400).entity((Object)json).build();
        }
        HealthCheckResponse response = new MongoHealthCheck(context, includeCollections).call();
        Response.ResponseBuilder responseBuilder = Response.ok();
        if (response.getState().equals((Object)HealthCheckResponse.State.DOWN)) {
            responseBuilder = responseBuilder.status(503);
        }
        String json = this.healthCheckSerializer(response);
        log.info("mongoCheck response is {}", (Object)json);
        return responseBuilder.entity((Object)json).build();
    }

    @GET
    @Path(value="/database")
    @Produces(value={"application/json"})
    public Response databaseCheck(@QueryParam(value="context") String context) throws JsonProcessingException {
        log.debug("databaseCheck called in the context {}", (Object)context);
        if (context == null) {
            HealthCheckResponse response = HealthCheckResponse.named((String)"mongo").withData("context", "is required parameter (e.g. context=/gcube/devsec/devVRE)").down().build();
            String json = this.healthCheckSerializer(response);
            log.info("databaseCheck error response is {}", (Object)json);
            return Response.status((int)400).entity((Object)json).build();
        }
        HealthCheckResponse response = new DatabaseHealthCheck(context).call();
        Response.ResponseBuilder responseBuilder = Response.ok();
        if (response.getState().equals((Object)HealthCheckResponse.State.DOWN)) {
            responseBuilder = responseBuilder.status(503);
        }
        String json = this.healthCheckSerializer(response);
        log.info("databaseCheck response is {}", (Object)json);
        return responseBuilder.entity((Object)json).build();
    }

    private String healthCheckSerializer(HealthCheckResponse response) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)response);
    }
}

