/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest.health;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.gcube.application.cms.implementations.ISInterface;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Readiness
@Liveness
public class DatabaseHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(DatabaseHealthCheck.class);
    private String context;
    public static final String SERVICE_NAME = "database";
    private static final int CONNECTION_TIMEOUT = 30;

    public HealthCheckResponse call() {
        return this.checkDatabase(this.context);
    }

    public DatabaseHealthCheck(String context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckResponse checkDatabase(String context) {
        log.debug("checkMongo in the context: {}", (Object)context);
        HealthCheckResponseBuilder buildHCRBuilder = HealthCheckResponse.named((String)SERVICE_NAME);
        ScopeProvider.instance.set(context);
        try {
            DatabaseConnection databaseConnection = null;
            ISInterface isInterface = (ISInterface)ImplementationProvider.get().getProvidedObjectByClass(ISInterface.class);
            try {
                if (isInterface == null) {
                    throw new Exception(ISInterface.class.getSimpleName() + " configuration is null for " + DatabaseConnection.class.getSimpleName());
                }
                databaseConnection = isInterface.queryForDatabase("Database", "postgis", "GNA_DB", "Concessioni");
                if (databaseConnection == null) {
                    throw new Exception(DatabaseConnection.class.getSimpleName() + " configuration is null");
                }
            }
            catch (Exception e) {
                log.error("Error on checking DB configuration: ", (Throwable)e);
                buildHCRBuilder.state(false);
                HealthCheckResponse healthCheckResponse = buildHCRBuilder.build();
                ScopeProvider.instance.reset();
                return healthCheckResponse;
            }
            boolean connectionStatus = this.checkDatabaseConnection(databaseConnection);
            buildHCRBuilder = this.appendDBInfo(buildHCRBuilder, databaseConnection);
            buildHCRBuilder.state(connectionStatus);
            log.info("checkDatabase is OK in the context: {}. State is {}", (Object)context, (Object)connectionStatus);
            HealthCheckResponse healthCheckResponse = buildHCRBuilder.build();
            return healthCheckResponse;
        }
        catch (Exception e) {
            log.error("Error on checkDatabase: ", (Throwable)e);
            log.warn("checkDatabase is KO in the context: {}", (Object)context);
            buildHCRBuilder.state(false);
            HealthCheckResponse healthCheckResponse = buildHCRBuilder.build();
            return healthCheckResponse;
        }
        finally {
            ScopeProvider.instance.reset();
        }
    }

    private HealthCheckResponseBuilder appendDBInfo(HealthCheckResponseBuilder buildHCRBuilder, DatabaseConnection connection) {
        buildHCRBuilder.withData("host", connection.getUrl() + "");
        buildHCRBuilder.withData("user ", connection.getUser());
        buildHCRBuilder.withData("pwd ", "****");
        return buildHCRBuilder;
    }

    private boolean checkDatabaseConnection(DatabaseConnection connectionParameters) {
        try {
            if (connectionParameters == null) {
                throw new ConfigurationException("connectionParameters is null");
            }
            Connection connection = DriverManager.getConnection(connectionParameters.getUrl(), connectionParameters.getUser(), connectionParameters.getPwd());
            if (connection != null && connection.isValid(30)) {
                log.debug("Connection to DB " + connectionParameters.getUrl() + " is OK!");
                return true;
            }
            log.debug("Connection to DB " + connectionParameters.getUrl() + " is KO!");
            return false;
        }
        catch (SQLException e) {
            log.warn("Error on connecting to DB: " + connectionParameters, (Throwable)e);
            return false;
        }
        catch (ConfigurationException e1) {
            log.warn("Error on reading connection configuration: " + connectionParameters, (Throwable)e1);
            return false;
        }
    }
}

