/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.util;

import org.gcube.application.cms.implementations.utils.UserUtils;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AuthorizedThread.class);
    private UserUtils.AuthenticatedUser authenticatedUser;
    private String umaToken;
    private String gcubeToken;

    public AuthorizedThread(UserUtils.AuthenticatedUser authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
        this.setContext();
    }

    private void setContext() {
        if (this.authenticatedUser == null) {
            return;
        }
        log.debug("{} id {} setting context {}", new Object[]{AuthorizedThread.class.getSimpleName(), this.getId(), this.authenticatedUser.getContext()});
        ScopeProvider.instance.set(this.authenticatedUser.getContext());
        this.umaToken = this.authenticatedUser.getUma_token();
        if (this.umaToken != null) {
            log.debug("{} id {} setting UMA token {}", new Object[]{AuthorizedThread.class.getSimpleName(), this.getId(), this.umaToken.substring(0, 20) + "_MASKED_TOKEN"});
            AccessTokenProvider.instance.set(this.umaToken);
        }
        this.gcubeToken = this.authenticatedUser.getGcube_token();
        if (this.gcubeToken != null) {
            log.debug("{} id {} legacy token {}", new Object[]{AuthorizedThread.class.getSimpleName(), this.getId(), this.gcubeToken.substring(0, 20) + "_MASKED_TOKEN"});
            SecurityTokenProvider.instance.set(this.gcubeToken);
        }
    }

    public void resetContext() {
        log.debug("{} id {} resetting context called", (Object)AuthorizedThread.class.getSimpleName(), (Object)this.getId());
        ScopeProvider.instance.reset();
        if (this.umaToken != null) {
            AccessTokenProvider.instance.reset();
        }
        if (this.gcubeToken != null) {
            SecurityTokenProvider.instance.reset();
        }
    }
}

