/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.application.geoportal.service.accounting.CalledMethodHandler;
import org.gcube.application.geoportal.service.engine.mongo.UCDManagerI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="ucd")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class UseCaseDescriptors {
    private static final Logger log = LoggerFactory.getLogger(UseCaseDescriptors.class);

    private UCDManagerI getManager() {
        try {
            return (UCDManagerI)ImplementationProvider.get().getProvidedObjectByClass(UCDManagerI.class);
        }
        catch (Throwable t) {
            log.error("Unable to get UCD Engine", t);
            throw new WebApplicationException("Unable to access UC Engine", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public UseCaseDescriptor createNew(UseCaseDescriptor toCreate) {
        String path = CalledMethodHandler.buildCalledResource((String)"POST", (String)"/ucd");
        CalledMethodHandler.setCalledMethod((String)(path + "/createNew"));
        return (UseCaseDescriptor)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Path(value="{usecase_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public UseCaseDescriptor update(@PathParam(value="usecase_id") String profileId, UseCaseDescriptor d) {
        String path = CalledMethodHandler.buildCalledResource((String)"PUT", (String)"/ucd");
        CalledMethodHandler.setCalledMethod((String)(path + "/" + profileId));
        return (UseCaseDescriptor)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{usecase_id}")
    public Boolean delete(@PathParam(value="usecase_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force) {
        String path = CalledMethodHandler.buildCalledResource((String)"DELETE", (String)"/ucd");
        CalledMethodHandler.setCalledMethod((String)(path + "/" + id));
        return (Boolean)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{usecase_id}")
    public UseCaseDescriptor getById(@PathParam(value="usecase_id") String id) {
        String path = CalledMethodHandler.buildCalledResource((String)"GET", (String)"/ucd");
        CalledMethodHandler.setCalledMethod((String)(path + "/" + id));
        return (UseCaseDescriptor)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/query")
    public Iterable<?> query(String queryString) {
        String path = CalledMethodHandler.buildCalledResource((String)"POST", (String)"/ucd");
        CalledMethodHandler.setCalledMethod((String)(path + "/" + "query"));
        return (Iterable)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ UCDManagerI access$100(UseCaseDescriptors x0) {
        return x0.getManager();
    }
}

