package org.gcube.application.aquamaps.images;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.gcube.application.aquamaps.images.model.Statistics;
import org.gcube.common.core.utils.logging.GCUBELog;

import com.j256.ormlite.dao.CloseableIterator;
import com.thoughtworks.xstream.XStream;

public class Monitor extends HttpServlet {

	private static final XStream xStream=new XStream();
	
	static {
		xStream.processAnnotations(Statistics.class);
	}
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2486605867155769417L;
	private static final GCUBELog logger=new GCUBELog(Monitor.class);
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		CloseableIterator<SpeciesInfo> it=null;
		resp.setContentType("application/xml");
		try{
			Common com=Common.get();
		it=com.getDao().closeableIterator();
		long speciesCount=0;
		long pictureCount=0;
		long nativeCount=0;
		long native2050Count=0;
		long suitableCount=0;
		long suitable2050Count=0;
		
		while(it.hasNext()){
			SpeciesInfo spec=it.next();
			speciesCount++;
			if(spec.getPic()!=null)pictureCount++;
			if(spec.getNativeURI()!=null)nativeCount++;
			if(spec.getNative2050URI()!=null)native2050Count++;
			if(spec.getSuitableURI()!=null)suitableCount++;
			if(spec.getSuitable2050URI()!=null) suitable2050Count++;			
		}
		
		PrintWriter writer=resp.getWriter();
		writer.write(xStream.toXML(new Statistics(speciesCount, pictureCount, nativeCount, native2050Count, suitableCount, suitable2050Count, com.getLastCompletedUpdate())));
		writer.flush();
		}catch(Exception e){
			logger.error("Unexpected Error ",e);
			resp.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		}finally{
			if(it!=null)try{
				it.close();
			}catch(Exception e){
				logger.fatal("Unable to close iterator ",e);
			}			
		}
	}
	
}
