package org.gcube.application.aquamaps.images;

import static org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin.maps;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

import org.gcube.application.aquamaps.images.exceptions.ImageNotFoundException;
import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.table.TableUtils;

public class Common {



	public static final String SPECIES_PARAM="species";

	public static final String IMAGE_JPEG="image/jpeg";

	private static final String IMAGE_BASE_URL="http://www.fishbase.org/images/thumbnails/jpg/";

	private static final Logger logger = LoggerFactory.getLogger(Common.class);

	private static final String configFile="config.properties";

	public static final String SCOPE_PROP="SCOPE";
	public static final String SUITABLE_PROP="SUITABLE_ID";
	public static final String SUITABLE_2050_PROP="SUITABLE_2050_ID";
	public static final String NATIVE_PROP="NATIVE_ID";
	public static final String NATIVE_2050_PROP="NATIVE_2050_ID";
	public static final String HELP_FILE="HELP_FILE";
	public static final String IMAGE_NOT_FOUND_FILE="IMAGE_NOT_FOUND_FILE";

	public static final String FETCH_ROUTINE_INTERVAL_MINUTES="FETCH_ROUTINE_INTERVAL_MINUTES";

	private static Common instance;

	public synchronized static Common get(){
		if(instance==null)instance=new Common();
		return instance;
	}



	private Properties props=new Properties();


	private Dao<SpeciesInfo,String> dao;

	private Long lastCompletedUpdate=0l;

	private Map<String,String> lastConfiguration=null;

	public Common() {
		try {
			Thread t=new Thread(){
				@Override
				public void run() {
					while(true)
						try {
							props.load(Common.class.getResourceAsStream(configFile));
							Thread.sleep(5*60*1000);
						} catch (IOException e) {
							logger.error("Unable to read configuration",e);
						}catch (InterruptedException e) {
						} 
				}
			};
			t.start();
			JdbcConnectionSource connectionSource=new JdbcPooledConnectionSource("jdbc:h2:mem:occurrence;DB_CLOSE_DELAY=-1");
			dao=DaoManager.createDao(connectionSource, SpeciesInfo.class);
			TableUtils.createTableIfNotExists(connectionSource, SpeciesInfo.class);
			SpeciesInfoImportThread thread=new SpeciesInfoImportThread(props);
			thread.start();
		} catch (SQLException e) {
			logger.error("Unable to create db",e);
		}
	}




	public org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps getAMInterface() throws Exception{
		ScopeProvider.instance.set(props.getProperty(SCOPE_PROP));
		return maps().build();
	}


	public InputStream getSuitableMap(String scientificName) throws SQLException, ImageNotFoundException, MalformedURLException, IOException{
		if(!dao.idExists(scientificName))throw new ImageNotFoundException();
		SpeciesInfo info=dao.queryForId(scientificName);
		if(info==null||info.getSuitableURI()==null)	throw new ImageNotFoundException();
		return new URL(info.getSuitableURI()).openStream();
	}

	public InputStream getSuitable2050Map(String scientificName)throws SQLException, ImageNotFoundException, MalformedURLException, IOException{
		if(!dao.idExists(scientificName))throw new ImageNotFoundException();
		SpeciesInfo info=dao.queryForId(scientificName);
		if(info==null||info.getSuitable2050URI()==null)	throw new ImageNotFoundException();
		return new URL(info.getSuitable2050URI()).openStream();
	}

	public InputStream getNativeMap(String scientificName)throws SQLException, ImageNotFoundException, MalformedURLException, IOException{
		if(!dao.idExists(scientificName))throw new ImageNotFoundException();
		SpeciesInfo info=dao.queryForId(scientificName);
		if(info==null||info.getNativeURI()==null)	throw new ImageNotFoundException();
		return new URL(info.getNativeURI()).openStream();
	}

	public InputStream getNative2050Map(String scientificName)throws SQLException, ImageNotFoundException, MalformedURLException, IOException{
		if(!dao.idExists(scientificName))throw new ImageNotFoundException();
		SpeciesInfo info=dao.queryForId(scientificName);
		if(info==null||info.getNative2050URI()==null)	throw new ImageNotFoundException();
		return new URL(info.getNative2050URI()).openStream();
	}


	public InputStream getSpeciesPicture(String scientificName)throws SQLException, ImageNotFoundException, MalformedURLException, IOException{
		if(!dao.idExists(scientificName))throw new ImageNotFoundException();
		SpeciesInfo info=dao.queryForId(scientificName);
		if(info==null||info.getPic()==null)	throw new ImageNotFoundException();
		if(info.getPic().startsWith("http")) return new URL(info.getPic()).openStream();
		return new URL(IMAGE_BASE_URL+"tn_"+info.getPic()).openStream();
	}


	public InputStream getImageNotFound(){
		return Common.class.getResourceAsStream(props.getProperty(IMAGE_NOT_FOUND_FILE));
	}

	public InputStream getHelpStream(){
		return Common.class.getResourceAsStream(props.getProperty(HELP_FILE));
	}

	public Dao<SpeciesInfo, String> getDao() {
		return dao;
	}

	public String getProperty(String property){
		return props.getProperty(property);
	}

	public void setLastCompletedUpdate(Long lastCompletedUpdate) {
		this.lastCompletedUpdate = lastCompletedUpdate;
	}

	public Long getLastCompletedUpdate() {
		return lastCompletedUpdate;
	}

	public void setLastConfiguration(Map<String, String> lastConfiguration) {
		this.lastConfiguration = lastConfiguration;
	}
	public Map<String, String> getLastConfiguration() {
		return lastConfiguration;
	}
}
