/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.SpeciesCSVLineProcessor;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpeciesInfoImportThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SpeciesInfoImportThread.class);
    private Properties props;

    public SpeciesInfoImportThread(Properties props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Hashtable configuration = (Hashtable)this.props.clone();
            try {
                String scope = (String)configuration.get("SCOPE");
                ScopeProvider.instance.set(scope);
                logger.trace("Fetching info in scope " + scope);
                Maps maps = (Maps)AbstractPlugin.maps().build();
                DataManagement dmService = (DataManagement)AbstractPlugin.dataManagement().build();
                int hspenID = 0;
                for (Field f : dmService.getDefaultSources()) {
                    if (!f.name().equals(ResourceType.HSPEN + "")) continue;
                    hspenID = f.getValueAsInteger();
                    logger.debug("Using hspen id " + hspenID);
                    break;
                }
                File toRead = maps.getCSVSpecies(hspenID, null, null);
                CSVReaderProcessor processor = new CSVReaderProcessor();
                processor.setDelimiter(',');
                processor.setHasHeader(true);
                SpeciesCSVLineProcessor lineProcessor = new SpeciesCSVLineProcessor(scope, Integer.parseInt((String)configuration.get("SUITABLE_ID")), Integer.parseInt((String)configuration.get("SUITABLE_2050_ID")), Integer.parseInt((String)configuration.get("NATIVE_ID")), Integer.parseInt((String)configuration.get("NATIVE_2050_ID")));
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(toRead), Charset.defaultCharset());
                processor.processStream((Reader)reader, (CSVLineProcessor)lineProcessor);
                logger.trace("Fetched " + lineProcessor.getCount());
                Common.get().setLastCompletedUpdate(Long.valueOf(System.currentTimeMillis()));
                Common.get().setLastConfiguration((Map)configuration);
                continue;
            }
            catch (Throwable e) {
                logger.error("Unexpected Error ", e);
                continue;
            }
            finally {
                try {
                    long minutes = Long.parseLong((String)configuration.get("FETCH_ROUTINE_INTERVAL_MINUTES"));
                    logger.trace("Going to execute again in " + minutes + " min");
                    SpeciesInfoImportThread.sleep((long)(minutes * 60L * 1000L));
                }
                catch (InterruptedException e) {
                }
                catch (Throwable t) {
                    logger.error("Unexpected exception ", t);
                }
                continue;
            }
            break;
        }
    }
}

