/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.enabling.model;

import java.util.HashMap;
import java.util.Set;
import org.gcube.application.aquamaps.enabling.model.DataSourceDescriptor;
import org.gcube.application.aquamaps.enabling.util.Constants;

public class DBDescriptor
extends DataSourceDescriptor {
    public static final String TABLESPACE_PREFIX = Constants.get().getDBTableSpacePrefix();
    public static final String TABLESPACE_COUNT = Constants.get().getDBTableSpaceCount();
    public static final String AQUAMAPS_WORLD_TABLE = Constants.get().getDBAquaMapsWorldTable();
    private DBType type = DBType.postgres;
    private Integer maxConnection = 20;
    private HashMap<String, String> properties = new HashMap();

    public DBDescriptor(String entryPoint, String user, String password, DBType type, Integer maxConnection) {
        super(entryPoint, user, password);
        this.type = type;
        this.maxConnection = maxConnection;
    }

    public DBType getType() {
        return this.type;
    }

    public Integer getMaxConnection() {
        return this.maxConnection;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.maxConnection == null ? 0 : this.maxConnection.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBDescriptor other = (DBDescriptor)obj;
        if (this.maxConnection == null ? other.maxConnection != null : !this.maxConnection.equals(other.maxConnection)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DBDescriptor [type=");
        builder.append((Object)this.type);
        builder.append(", maxConnection=");
        builder.append(this.maxConnection);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append(", getEntryPoint()=");
        builder.append(this.getEntryPoint());
        builder.append(", getUser()=");
        builder.append(this.getUser());
        builder.append(", getPassword()=");
        builder.append(this.getPassword());
        builder.append("]");
        return builder.toString();
    }

    public static enum DBType {
        mysql,
        postgres;

    }
}

