/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.application.perform.service.engine.impl.Query;
import org.gcube.application.perform.service.engine.impl.SchemaDefinition;
import org.gcube.application.perform.service.engine.model.CSVExportRequest;
import org.gcube.application.perform.service.engine.model.DBField;

public class ExportCSVQuery
extends Query {
    private Map<String, Map<String, String>> mappings = new HashMap();
    private String tablename;
    private CSVExportRequest theRequest;
    private SchemaDefinition schema;
    private Map<String, DBField> actualStructure;
    private ArrayList<String> exportCSVFieldOrder;

    public ExportCSVQuery(String query, DBField[] queryParams, CSVExportRequest theRequest, SchemaDefinition schema, Map<String, DBField> actualStructure, ArrayList<String> exportFieldsOrder) {
        super(query, queryParams);
        this.theRequest = theRequest;
        this.schema = schema;
        this.actualStructure = actualStructure;
        this.exportCSVFieldOrder = exportFieldsOrder;
    }

    public void setMapping(String field, Map<String, String> mapping) {
        this.mappings.put(field, mapping);
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getQuery() {
        String selectedFields = this.getFieldList();
        String conditionString = this.getConditionString();
        if (conditionString.length() > 0) {
            conditionString = "WHERE " + conditionString;
        }
        return String.format("SELECT %1$s FROM %2$s %3$s", selectedFields, this.tablename, conditionString);
    }

    public String getQueryForMappedFields(String filterMappingKey, String ... fields) {
        StringBuilder b = new StringBuilder();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            b.append(String.valueOf(f) + ",");
            ++n2;
        }
        b.setLength(b.lastIndexOf(","));
        Query.log.debug("Creating query for fields {} against table {} ", (Object)b, (Object)this.tablename);
        String selectedFields = b.toString();
        String condition = this.getFilterWithMapping(filterMappingKey);
        return String.format("SELECT %1$s FROM %2$s %3$s", selectedFields, this.tablename, condition);
    }

    private String getFilterWithMapping(String mappingFilterKey) {
        StringBuilder conditionBuilder = new StringBuilder("WHERE ");
        if (this.mappings.containsKey(mappingFilterKey) && !((Map)this.mappings.get(mappingFilterKey)).isEmpty()) {
            String actualField = this.actualField(mappingFilterKey);
            Query.log.debug("Setting filter By Mappings for field {}, size {} ", (Object)actualField, (Object)((Map)this.mappings.get(mappingFilterKey)).size());
            conditionBuilder.append("(");
            for (Map.Entry mappingFilter : ((Map)this.mappings.get(mappingFilterKey)).entrySet()) {
                conditionBuilder.append(String.format("%1$s = '%2$s' OR", actualField, mappingFilter.getKey()));
            }
            conditionBuilder.setLength(conditionBuilder.lastIndexOf("OR"));
            conditionBuilder.append(")");
            String filteringCondition = this.getConditionString();
            if (filteringCondition.length() > 0) {
                conditionBuilder.append(" AND (" + filteringCondition + ")");
            }
        } else {
            Query.log.debug("No mappings to search For ");
            conditionBuilder.append("FALSE");
        }
        return conditionBuilder.toString();
    }

    private String getConditionString() {
        ArrayList<String> orGroups = new ArrayList<String>();
        if (this.theRequest.getAreas().size() > 0 && this.schema.getAreaField() != null && this.exists(this.schema.getAreaField())) {
            orGroups.add(this.getFilterByMultipleValues(this.theRequest.getAreas(), this.schema.getAreaField()));
        }
        if (this.theRequest.getQuarters().size() > 0 && this.schema.getQuarterField() != null && this.exists(this.schema.getQuarterField())) {
            orGroups.add(this.getFilterByMultipleValues(this.theRequest.getQuarters(), this.schema.getQuarterField()));
        }
        if (this.theRequest.getSpeciesIds().size() > 0 && this.schema.getSpeciesField() != null && this.exists(this.schema.getSpeciesField())) {
            orGroups.add(this.getFilterByMultipleValues(this.theRequest.getSpeciesIds(), this.schema.getSpeciesField()));
        }
        if (this.theRequest.getPeriods().size() > 0 && this.schema.getPeriodField() != null && this.exists(this.schema.getPeriodField())) {
            orGroups.add(this.getFilterByMultipleValues(this.theRequest.getPeriods(), this.schema.getPeriodField()));
        }
        StringBuilder toReturn = new StringBuilder("");
        for (String orGroup : orGroups) {
            toReturn.append("(" + orGroup + ") AND ");
        }
        if (toReturn.length() > 0) {
            toReturn.setLength(toReturn.lastIndexOf("AND"));
        }
        return toReturn.toString();
    }

    private String getFieldList() {
        StringBuilder b = new StringBuilder();
        for (String label : this.exportCSVFieldOrder) {
            DBField f = (DBField)this.actualStructure.get(label);
            b.append(String.valueOf(f.getFieldName()) + ",");
        }
        return b.toString().substring(0, b.lastIndexOf(","));
    }

    private String actualField(String label) {
        return ((DBField)this.actualStructure.get(label)).getFieldName();
    }

    private boolean exists(String label) {
        return this.actualStructure.containsKey(label);
    }

    private String getFilterByMultipleValues(Set<String> filterValues, String filterLabel) {
        String field = this.actualField(filterLabel);
        StringBuilder toReturn = new StringBuilder();
        for (String p : filterValues) {
            toReturn.append(String.format("%1$s = '%2$s' OR", field, p));
        }
        toReturn.setLength(toReturn.lastIndexOf("OR"));
        return toReturn.toString();
    }
}

