/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.utils;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeUtils {
    private static final Logger log = LoggerFactory.getLogger(ScopeUtils.class);

    public static String getCurrentScope() {
        String scope = ScopeProvider.instance.get();
        if (scope != null) {
            log.debug("Found scope provider {}, skipping token", (Object)scope);
            return scope;
        }
        try {
            log.debug("Scope provider not set, reverting to token");
            String token = SecurityTokenProvider.instance.get();
            log.debug("Token is : " + token);
            if (token == null) {
                throw new Exception("Security Token is null");
            }
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            return entry.getContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to evaluate scope ", e);
        }
    }

    public static String getCaller() {
        return SecurityTokenProvider.instance.get();
    }

    public static String getClientId(String token) throws ObjectNotFound, Exception {
        AuthorizationEntry entry = Constants.authorizationService().get(token);
        return entry.getClientInfo().getId();
    }
}

