/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.rest;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.application.perform.service.PerformServiceManager;
import org.gcube.application.perform.service.engine.MappingManager;
import org.gcube.application.perform.service.engine.model.BeanNotFound;
import org.gcube.application.perform.service.engine.model.DBField;
import org.gcube.application.perform.service.engine.model.DBQueryDescriptor;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.model.InvalidRequestException;
import org.gcube.application.perform.service.engine.model.anagraphic.Batch;
import org.gcube.application.perform.service.engine.model.anagraphic.Farm;
import org.gcube.application.perform.service.rest.InterfaceCommons;
import org.gcube.application.perform.service.rest.MyAuthException;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="mappings")
@ManagedBy(value=PerformServiceManager.class)
public class Mappings {
    private static final Logger log = LoggerFactory.getLogger(Mappings.class);
    @Inject
    private MappingManager mappings;

    @GET
    @Path(value="batch")
    @Produces(value={"application/json"})
    @AuthorizationControl(allowedUsers={"statistical.manager"}, exception=MyAuthException.class)
    public Batch getBatch(@QueryParam(value="name") String name, @QueryParam(value="type") String type, @QueryParam(value="farmid") Long farmid) {
        InterfaceCommons.checkMandatory((Object)name, (String)"name");
        InterfaceCommons.checkMandatory((Object)type, (String)"type");
        InterfaceCommons.checkMandatory((Object)farmid, (String)"farmid");
        HashMap condition = new HashMap();
        condition.put(DBField.Batch.fields.get("name"), name);
        condition.put(DBField.Batch.fields.get("type"), type);
        condition.put(DBField.Batch.fields.get("farmid"), farmid);
        DBQueryDescriptor desc = new DBQueryDescriptor(condition);
        try {
            return this.mappings.getBatch(desc);
        }
        catch (BeanNotFound e) {
            log.debug("Exception while getting Batch", (Throwable)e);
            throw new WebApplicationException("Unable to find Batch with condition " + desc, Response.Status.NOT_FOUND);
        }
        catch (SQLException e) {
            log.debug("Exception while getting Batch", (Throwable)e);
            throw new WebApplicationException("Unexpected Exception occurred while dealing with database.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (InvalidRequestException e) {
            log.debug("Exception while getting Batch", (Throwable)e);
            throw new WebApplicationException("Unable to search for Batch. ", (Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (InternalException e) {
            log.warn("Unexpected Exception while getting Batch", (Throwable)e);
            throw new WebApplicationException("Unexpected Exception.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception while getting Batch", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="farm")
    @Produces(value={"application/json"})
    @AuthorizationControl(allowedUsers={"statistical.manager"}, exception=MyAuthException.class)
    public Farm getFarm(@Context UriInfo info) {
        DBQueryDescriptor desc = null;
        try {
            String farmidString = (String)info.getQueryParameters().getFirst((Object)"farmid");
            InterfaceCommons.checkMandatory((Object)farmidString, (String)"farmid");
            desc = new DBQueryDescriptor(Collections.singletonMap(DBField.Farm.fields.get("id"), Long.parseLong(farmidString)));
        }
        catch (WebApplicationException e) {
            try {
                String farmUUID = (String)info.getQueryParameters().getFirst((Object)"farmuuid");
                InterfaceCommons.checkMandatory((Object)farmUUID, (String)"farmuuid");
                desc = new DBQueryDescriptor(Collections.singletonMap(DBField.Farm.fields.get("uuid"), farmUUID));
            }
            catch (WebApplicationException e1) {
                throw new WebApplicationException("Specify either farmuuid or farmid", Response.Status.BAD_REQUEST);
            }
        }
        try {
            return this.mappings.getFarm(desc);
        }
        catch (BeanNotFound e) {
            log.debug("Exception while getting Farm", (Throwable)e);
            throw new WebApplicationException("Unable to find Farm with condition " + desc, Response.Status.NOT_FOUND);
        }
        catch (SQLException e) {
            log.debug("Exception while getting Farm", (Throwable)e);
            throw new WebApplicationException("Unexpected Exception occurred while dealing with database.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (InvalidRequestException e) {
            log.debug("Exception while getting Farm", (Throwable)e);
            throw new WebApplicationException("Unable to search for Farm. ", (Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (InternalException e) {
            log.warn("Unexpected Exception while getting Farm", (Throwable)e);
            throw new WebApplicationException("Unexpected Exception.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (NumberFormatException t) {
            throw new WebApplicationException("Invalid FarmID format " + desc, Response.Status.BAD_REQUEST);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception while getting Farm", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

