/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.model.importer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.gcube.application.perform.service.engine.DataBaseManager;
import org.gcube.application.perform.service.engine.impl.ExportCSVQuery;
import org.gcube.application.perform.service.engine.impl.Queries;
import org.gcube.application.perform.service.engine.impl.Query;
import org.gcube.application.perform.service.engine.impl.SchemaDefinition;
import org.gcube.application.perform.service.engine.model.CSVExportRequest;
import org.gcube.application.perform.service.engine.model.DBField;
import org.gcube.application.perform.service.engine.model.DBQueryDescriptor;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.model.InvalidRequestException;
import org.gcube.application.perform.service.engine.model.importer.CSVRecordConverter;
import org.gcube.application.perform.service.engine.model.importer.ImportRoutineDescriptor;
import org.gcube.application.perform.service.engine.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImportedTable {
    private static final Logger log = LoggerFactory.getLogger(ImportedTable.class);
    private Map<String, DBField> labels;
    private ArrayList<String> csvFields;
    private String tablename;
    private Query insertQuery;
    private SchemaDefinition schema;
    int MAX_LENGTH = 25;

    public String toString() {
        return "ImportedTable [tablename=" + this.tablename + "]";
    }

    public ImportedTable(String tablename, SchemaDefinition schema, ArrayList<DBField> csvFieldsDefinition) throws InternalException {
        this.schema = schema;
        this.tablename = tablename;
        this.csvFields = new ArrayList();
        this.labels = new HashMap();
        for (DBField field : csvFieldsDefinition) {
            String escaped = this.escapeString(field.getFieldName());
            this.csvFields.add(field.getFieldName());
            this.labels.put(field.getFieldName(), new DBField(field.getType(), escaped));
        }
        this.check(schema.getAssociationUUIDField());
        this.check(schema.getBatchUUIDField());
        this.check(schema.getCompanyUUIDField());
        this.check(schema.getFarmUUIDField());
        this.check(schema.getAreaField());
        this.check(schema.getPeriodField());
        this.check(schema.getQuarterField());
        this.check(schema.getSpeciesField());
        for (String f : schema.getToReportFields()) {
            this.check(f);
        }
        this.insertQuery = this.prepareInsertionQuery();
    }

    private void check(String field) throws InternalException {
        if (field != null && !this.labels.containsKey(field)) {
            throw new InternalException("Incoherent schema definition for table " + this.tablename + ". Field " + field + " not found in csv.");
        }
    }

    private DBField getRoutineIdField() {
        return new DBField(-5, this.schema.getRoutineIdFieldName());
    }

    private Query prepareInsertionQuery() {
        StringBuilder fieldList = new StringBuilder();
        StringBuilder valueString = new StringBuilder();
        ArrayList<DBField> queryFields = new ArrayList<DBField>();
        for (DBField f : this.labels.values()) {
            queryFields.add(f);
            fieldList.append(f.getFieldName() + ",");
            valueString.append("?,");
        }
        queryFields.add(this.getRoutineIdField());
        String insertSQL = String.format("INSERT INTO %1$s (%2$s) VALUES (%3$s)", this.tablename, fieldList + this.getRoutineIdField().getFieldName(), valueString + "?");
        return new Query(insertSQL, queryFields.toArray(new DBField[queryFields.size()]));
    }

    public String createStatement() {
        StringBuilder fieldDefinitions = new StringBuilder();
        for (DBField f : this.labels.values()) {
            String type = "text";
            switch (f.getType()) {
                case -5: {
                    type = "bigint";
                    break;
                }
                case 7: {
                    type = "real";
                }
            }
            fieldDefinitions.append(f.getFieldName() + " " + type + ",");
        }
        String standardDefinitions = String.format("%1$s bigint,FOREIGN KEY (%1$s) REFERENCES imports(id)", this.getRoutineIdField().getFieldName());
        return String.format("CREATE TABLE IF NOT EXISTS %1$s (%2$s, %3$s)", this.tablename, fieldDefinitions.substring(0, fieldDefinitions.lastIndexOf(",")), standardDefinitions);
    }

    public boolean matchesSchema(ArrayList<String> toMatchSchema) {
        return this.csvFields.equals(toMatchSchema);
    }

    public DBQueryDescriptor getSetRow(Map<String, String> csvRow, Long routineId) {
        DBQueryDescriptor desc = new DBQueryDescriptor();
        for (Map.Entry<String, String> csvField : csvRow.entrySet()) {
            DBField toSetField = (DBField)this.labels.get(csvField.getKey());
            Object value = csvField.getValue();
            if (csvField.getValue() == null || csvField.getValue().isEmpty()) {
                value = null;
            }
            if (value != null) {
                try {
                    switch (toSetField.getType()) {
                        case -5: {
                            value = Long.parseLong((String)value);
                            break;
                        }
                        case 7: {
                            value = Double.parseDouble((String)value);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Unable to parse field {} value was {} ", (Object)csvField.getKey(), (Object)csvField.getValue());
                    throw e;
                }
            }
            desc.add(toSetField, value);
        }
        desc.add(this.getRoutineIdField(), (Object)routineId);
        return desc;
    }

    public Query getInsertQuery() {
        return this.insertQuery;
    }

    public String getTableName() {
        return this.tablename;
    }

    public int cleanByImportRoutine(ImportRoutineDescriptor toClean, Connection conn) throws InvalidRequestException, SQLException {
        DBField routineField = this.getRoutineIdField();
        Query cleanQuery = new Query(String.format("DELETE FROM %1$s WHERE %2$s =?", this.tablename, routineField.getFieldName()), new DBField[]{routineField});
        return cleanQuery.get(conn, new DBQueryDescriptor(routineField, (Object)toClean.getId())).executeUpdate();
    }

    public Map<String, String> exportStatistics() throws SQLException, InternalException {
        log.debug("Exporting statistics from {} ", (Object)this);
        Connection conn = DataBaseManager.get().getConnection();
        try {
            throw new RuntimeException("Not Yet implemented");
        }
        catch (Throwable throwable) {
            conn.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> exportCSV(CSVExportRequest request) throws InvalidRequestException, SQLException, InternalException, IOException {
        log.debug("Exporting {} from {} ", (Object)request, (Object)this);
        try (Connection conn = DataBaseManager.get().getConnection();){
            CSVRecordConverter queryConverter = new CSVRecordConverter(this.labels);
            ExportCSVQuery exportQuery = new ExportCSVQuery("", null, request, this.schema, this.labels, this.csvFields);
            exportQuery.setTablename(this.tablename);
            HashMap<String, String> farmMapping = new HashMap<String, String>();
            HashMap<String, String> companyMapping = new HashMap<String, String>();
            HashMap<String, String> associationMapping = new HashMap<String, String>();
            HashMap<String, String> batchMapping = new HashMap<String, String>();
            PreparedStatement psFarm = Queries.GET_FARM_BY_ID.prepare(conn);
            PreparedStatement psBatch = Queries.GET_BATCH_BY_FARM_ID.prepare(conn);
            for (Long farmid : request.getFarmIds()) {
                ResultSet rsFarm = Queries.GET_FARM_BY_ID.fill(psFarm, new DBQueryDescriptor((DBField)DBField.Farm.fields.get("id"), (Object)farmid)).executeQuery();
                if (!rsFarm.next()) {
                    log.warn("Unable to Find farmID " + farmid);
                    continue;
                }
                farmMapping.put(rsFarm.getString("uuid"), rsFarm.getString("name"));
                companyMapping.put(rsFarm.getString("companyuuid"), rsFarm.getString("company_name"));
                associationMapping.put(rsFarm.getString("associationuuid"), rsFarm.getString("association_name"));
                ResultSet rsBatch = Queries.GET_BATCH_BY_FARM_ID.fill(psBatch, new DBQueryDescriptor((DBField)DBField.Batch.fields.get("farmid"), (Object)farmid)).executeQuery();
                while (rsBatch.next()) {
                    batchMapping.put(rsBatch.getString("uuid"), rsBatch.getString("name"));
                }
            }
            if (this.schema.getAssociationUUIDField() != null) {
                log.debug("Setting Association Mapping : " + associationMapping);
                exportQuery.setMapping(this.schema.getAssociationUUIDField(), associationMapping);
                queryConverter.setMapping(this.schema.getAssociationUUIDField(), associationMapping);
            }
            if (this.schema.getCompanyUUIDField() != null) {
                log.debug("Setting Company Mapping : " + companyMapping);
                exportQuery.setMapping(this.schema.getCompanyUUIDField(), companyMapping);
                queryConverter.setMapping(this.schema.getCompanyUUIDField(), companyMapping);
            }
            if (this.schema.getFarmUUIDField() != null) {
                log.debug("Setting Farm Mapping : " + farmMapping);
                exportQuery.setMapping(this.schema.getFarmUUIDField(), farmMapping);
                queryConverter.setMapping(this.schema.getFarmUUIDField(), farmMapping);
            }
            if (this.schema.getBatchUUIDField() != null) {
                log.debug("Setting Batch Mapping : " + batchMapping);
                exportQuery.setMapping(this.schema.getBatchUUIDField(), batchMapping);
                queryConverter.setMapping(this.schema.getBatchUUIDField(), batchMapping);
            }
            if (this.schema.getFarmUUIDField() != null) {
                queryConverter.setCondition(this.schema.getFarmUUIDField(), farmMapping.keySet());
            }
            log.trace("Performing actual query towards {} ", (Object)this.tablename);
            HashMap<String, String> toReturn = new HashMap<String, String>();
            String sqlExport = exportQuery.getQuery();
            log.debug("Query is {} ", (Object)sqlExport);
            Statement stmt = conn.createStatement();
            ResultSet csvRs = stmt.executeQuery(sqlExport);
            toReturn.put(this.schema.getRelatedDescription(), ImportedTable.putIntoStorage((ResultSet)csvRs, (String[])this.csvFields.toArray(new String[this.csvFields.size()]), (CSVRecordConverter)queryConverter));
            if (this.schema.getToReportFields().size() > 0) {
                ArrayList toExtractCSVFields = this.schema.getToReportFields();
                queryConverter.reset();
                log.trace("Extracting {} from {} ", (Object)this.tablename);
                String[] toExtractFields = new String[toExtractCSVFields.size()];
                for (String label : toExtractCSVFields) {
                    String fieldName;
                    toExtractFields[toExtractCSVFields.indexOf((Object)label)] = fieldName = ((DBField)this.labels.get(label)).getFieldName();
                }
                String sqlPersonal = exportQuery.getQueryForMappedFields(this.schema.getFarmUUIDField(), toExtractFields);
                log.debug("Query is {} ", (Object)sqlPersonal);
                csvRs = stmt.executeQuery(sqlPersonal);
                toReturn.put(this.schema.getRelatedDescription() + "_internal", ImportedTable.putIntoStorage((ResultSet)csvRs, (String[])this.schema.getToReportLabels().toArray(new String[this.schema.getToReportLabels().size()]), (CSVRecordConverter)queryConverter));
            }
            HashMap<String, String> hashMap = toReturn;
            return hashMap;
        }
    }

    public SchemaDefinition getSchema() {
        return this.schema;
    }

    private String escapeString(String fieldname) {
        String toReturn = fieldname;
        if (toReturn.length() > this.MAX_LENGTH) {
            toReturn = toReturn.substring(0, this.MAX_LENGTH);
        }
        DBField clashing = new DBField(0, "\"" + toReturn + "\"");
        int counter = 1;
        while (this.labels.containsValue(clashing)) {
            clashing = new DBField(0, "\"" + toReturn + "_" + counter + "\"");
            ++counter;
        }
        return clashing.getFieldName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String putIntoStorage(ResultSet toExport, String[] headers, CSVRecordConverter converter) throws IOException, SQLException {
        CSVPrinter printer = null;
        File dataFile = null;
        try {
            dataFile = File.createTempFile("csv_out", ".csv");
            printer = CSVFormat.DEFAULT.withHeader(headers).print((Appendable)new FileWriter(dataFile));
            while (toExport.next()) {
                printer.printRecord(converter.convert(toExport));
            }
            printer.flush();
            String string = StorageUtils.putOntoStorage((File)dataFile);
            return string;
        }
        finally {
            if (printer != null) {
                printer.close();
            }
            if (dataFile != null) {
                Files.deleteIfExists(dataFile.toPath());
            }
        }
    }
}

