
var connectionLinks,
	panelSelections,
	visData,
	dID,
	w,h;

//this function is the entry point of this page (it's called from the GXT widget)
function doVisualise(serverLinksJSON, panelSelectionsJSON, divID, width, height){
	dID = divID; 
	w = width;
	h = height;
	connectionLinks = JSON.parse(serverLinksJSON);   //undecode JSON-encoded links from server and add them into global connectionLinks
	panelSelections = JSON.parse(panelSelectionsJSON);
	initiateVisualisation(divID);
}


function initiateVisualisation(divID){
	//remove the previous visualisation
	$("#"+dID).children("svg").remove();
	//initiate the visualisation
	visualisation = staticbubbleplot(divID, w, h);
	//and do visualise
	visualise(connectionLinks,panelSelections.number,panelSelections.fromDate,panelSelections.toDate,panelSelections.order);
}


function visualise(connectionLinks, rowLimit, fromDate, toDate, sorting){
	var jsonDataLink = connectionLinks["geoserver"]+connectionLinks["workspace"]+"/ows?service=WFS&version=1.0.0&request=GetFeature&typeName="+connectionLinks["workspace"]+":"+connectionLinks["layerName"]+"&maxFeatures="+rowLimit+"&outputFormat=json&viewparams=fromDate:'"+fromDate+"';toDate:'"+toDate+"';order:"+sorting;
	//load the correct JSONdata from geoserver
	ajaxJSONPcall(jsonDataLink,"doVisualisation"); //and the callback does the actual visualisation
}

//the following will serve as a JSONP solution to cross domain http calls
//note that the function name is embedded on the json string returned by the geoserver
function ajaxJSONPcall (url, callbackfunctionName){
	$.ajax({
    	cache : false,
    	type : 'GET',
  //  	async : false,
    	url : url+'&format_options=callback:'+callbackfunctionName,
        dataType: 'jsonp',
        crossDomain : true,
        success: function(data){
        	alert(data);
        },
        failure: function(error){
			alert(error);
        }
    });

}


function doVisualisation(visualisationData){
	visData = visualisationData;
	//this is the actual visualisation
	visualisation.visualise(visualisationData);
}

function resizeVisualisation(width,height){
	w = width;
	h = height;
	//remove the previous visualisation
	$("#"+dID).children("svg").remove();
	//initiate the visualisation
	visualisation = staticbubbleplot(divID, w, h);
	visualisation.visualise(visualisationData);
}
