
package org.visualisation.client;


import org.visualisation.client.Date.PopupDatePicker;
import org.visualisation.resources.Icons;

import com.sencha.gxt.cell.core.client.form.ComboBoxCell;
import com.sencha.gxt.data.shared.Store;
import com.sencha.gxt.widget.core.client.Slider;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.info.Info;
import com.sencha.gxt.widget.core.client.menu.Item;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IntegerBox;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

public class ControlPanel implements IsWidget {

	private ToolBar toolBar;
	
	private Label showthe = new Label("Show the");
	private TextButton numberButton;
	private int number;
	private ListBox order;
	private Label species;
	private Label from;
	private PopupDatePicker fromDate;
	private Label to;
	private PopupDatePicker toDate;
	private TextButton submit;

	
	@Override
	public Widget asWidget() {

		toolBar = new ToolBar();
		toolBar.setSpacing(7);
		
		showthe = new Label("Show top");
		species = new Label("species");
		from = new Label("from");
		to = new Label("to");
		order = new ListBox();
		number = 0;
		order.insertItem("least common", "asc", 0);
		order.insertItem("most common", "desc", 0);
		order.setStyleName("VisListBox", true);
		fromDate = new PopupDatePicker();
		toDate = new PopupDatePicker();
		submit = new TextButton("Visualise");
//		submit.setIcon(AbstractImagePrototype.create(Icons.vis()));

		SelectionHandler<Item> handler = new SelectionHandler<Item>() {
			@Override
			public void onSelection(SelectionEvent<Item> event) {
				MenuItem item = (MenuItem) event.getSelectedItem();
//				Info.display("Action", "You selected the " + item.getText());
				number = Integer.parseInt(item.getText());
				numberButton.setText(String.valueOf(number));
			}
		};
		
	    numberButton = new TextButton("--");
	    Menu speciesNum = new Menu();
	    speciesNum.addSelectionHandler(handler);
	    speciesNum.setMaxHeight(200);
	    for (int i = 1; i <= 100; i++)
	    	speciesNum.add(new MenuItem(String.valueOf(i)));
	    numberButton.setMenu(speciesNum);
	    
	    toolBar.add(showthe);
	    toolBar.add(numberButton);
		toolBar.add(order);
		toolBar.add(species);
		toolBar.add(from);
	    toolBar.add(fromDate);
	    toolBar.add(to);
	    toolBar.add(toDate);
		toolBar.add(submit);
		return toolBar;
	}

	/**
	 * @wbp.parser.entryPoint
	 */
	public void onModuleLoad() {
		RootPanel rootPanel = RootPanel.get();
		rootPanel.add(asWidget());
	}
	
	public String getPanelValuesJSON() throws JSONException{
		JSONObject obj = new JSONObject();
		obj.put("order", new JSONString(order.getValue(order.getSelectedIndex())));		
		obj.put("number",new JSONString(String.valueOf(number)));
		obj.put("fromDate",new JSONString(fromDate.getValue().toString()));
		obj.put("toDate",new JSONString(toDate.getValue().toString()));
		return obj.toString();
	}
	
	public TextButton getSubmitButton(){
		return this.submit;
	}
	
//	public int getNumber(){
//		return this.number;
//	}
	
	
	public boolean areAllSet(){
		if(order.getValue(order.getSelectedIndex()).isEmpty()||(number==0)||(fromDate.getValue()==null)||(toDate.getValue()==null))
			return false;
		return true;
	}
	
	
	
	public void setWidth(String width){
//		this.toolBar.setWidth(width);
		this.toolBar.setWidth("auto");
	}
	
	public void getHeight(){
//		this.toolBar
	}
	
}