/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.context;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.gcube.application.speciesmanager.consumers.RuntimeResourceConsumer;
import org.gcube.application.speciesmanager.manager.Manager;
import org.gcube.application.speciesmanager.manager.ManagerPTContext;
import org.gcube.application.speciesmanager.plugin.PluginManager;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.globus.wsrf.ResourceKey;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private ISNotifier notifier;
    private String runtimeResourceCategory;

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/application/speciesmanager";
    }

    protected void onInitialisation() throws Exception {
        this.runtimeResourceCategory = (String)ServiceContext.getContext().getProperty("runtimeResourceCategory", new boolean[]{true});
        this.notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
        super.onInitialisation();
    }

    protected void onReady() throws Exception {
        super.onReady();
        ServiceContext.getContext().getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new RINotificationConsumer(), new GCUBEResource.ResourceTopic[0]);
    }

    public String getRuntimeResourceCategory() {
        return this.runtimeResourceCategory;
    }

    public void activatePlugin(GCUBERuntimeResource resource, GCUBEScope scope) {
        ServiceContext.getContext().setScope(scope);
        PluginManager.get(scope).add(resource);
        try {
            Manager manager = (Manager)ManagerPTContext.getContext().getWSHome().find((ResourceKey)ManagerPTContext.getContext().makeKey("manager"));
            manager.addPluginsDescription(scope);
        }
        catch (Exception e) {
            this.logger.error((Object)"errror retrieving the resource", (Throwable)e);
        }
    }

    public void updatePlugin(GCUBERuntimeResource resource, GCUBEScope scope) {
        ServiceContext.getContext().setScope(scope);
        PluginManager.get(scope).update(resource);
        try {
            Manager manager = (Manager)ManagerPTContext.getContext().getWSHome().find((ResourceKey)ManagerPTContext.getContext().makeKey("manager"));
            manager.removePluginsDescription(scope);
            manager.addPluginsDescription(scope);
        }
        catch (Exception e) {
            this.logger.error((Object)"errror retrieving the resource", (Throwable)e);
        }
    }

    public void removePlugin(GCUBEScope scope) {
        ServiceContext.getContext().setScope(scope);
        PluginManager.get(scope).remove();
        try {
            Manager manager = (Manager)ManagerPTContext.getContext().getWSHome().find((ResourceKey)ManagerPTContext.getContext().makeKey("manager"));
            manager.removePluginsDescription(scope);
            manager.addPluginsDescription(scope);
        }
        catch (Exception e) {
            this.logger.error((Object)"errror retrieving the resource", (Throwable)e);
        }
    }

    private boolean createResourceInScope(GCUBEScope scope) {
        try {
            this.logger.info((Object)("creating resource in scope " + scope.getName()));
            ServiceContext.getContext().setScope(scope);
            ManagerPTContext.getContext().getWSHome().create(ManagerPTContext.getContext().makeKey("manager"), new Object[0]);
            ISNotifier.GCUBENotificationTopic runtimeResourceTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "RuntimeResource"));
            runtimeResourceTopic.setPrecondition("//profile[contains(.,'<Category>" + this.runtimeResourceCategory + "</Category>')] and //invocationScope/text()='" + scope.toString() + "'");
            this.notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)RuntimeResourceConsumer.getConsumer(scope), Collections.singletonList(runtimeResourceTopic), (GCUBESecurityManager)this, new GCUBEScope[]{scope.getType() == GCUBEScope.Type.VRE ? scope.getEnclosingScope() : scope});
        }
        catch (Exception e) {
            this.logger.warn((Object)("error creating resource in scope " + scope), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean removeResourceInScope(GCUBEScope scope) {
        try {
            this.logger.info((Object)("removing resource in scope " + scope.getName()));
            ServiceContext.getContext().setScope(scope);
            ManagerPTContext.getContext().getWSHome().remove((ResourceKey)ManagerPTContext.getContext().makeKey("manager"));
            ISNotifier.GCUBENotificationTopic runtimeResourceTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "RuntimeResource"));
            runtimeResourceTopic.setPrecondition("//profile[contains(.,'<Category>" + this.runtimeResourceCategory + "</Category>')] and //invocationScope/text()='" + scope.toString() + "'");
            this.notifier.unregisterFromISNotification((GCUBESecurityManager)this, Collections.singletonList(runtimeResourceTopic), new GCUBEScope[]{scope.getType() == GCUBEScope.Type.VRE ? scope.getEnclosingScope() : scope});
        }
        catch (Exception e) {
            this.logger.warn((Object)("error removing resource in scope " + scope), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void onShutdown() throws Exception {
        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
            this.removeResourceInScope(scope);
        }
        super.onShutdown();
    }

    public class RINotificationConsumer
    extends GCUBEResource.ResourceConsumer {
        protected void onAddScope(GCUBEResource.AddScopeEvent event) {
            GCUBEScope[] gCUBEScopeArray = (GCUBEScope[])event.getPayload();
            int n = gCUBEScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GCUBEScope scope = gCUBEScopeArray[n2];
                ServiceContext.this.createResourceInScope(scope);
                ++n2;
            }
            super.onAddScope(event);
        }

        protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
            GCUBEScope[] gCUBEScopeArray = (GCUBEScope[])event.getPayload();
            int n = gCUBEScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GCUBEScope scope = gCUBEScopeArray[n2];
                ServiceContext.this.removeResourceInScope(scope);
                ++n2;
            }
            super.onRemoveScope(event);
        }
    }
}

