/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.occurrences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.gcube.application.speciesmanager.context.ServiceContext;
import org.gcube.application.speciesmanager.plugin.PluginManager;
import org.gcube.application.speciesmanager.stubs.model.Occurrence;
import org.gcube.application.speciesmanager.stubs.model.binding.Bindings;
import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.application.speciesmanager.stubs.readers.StringReader;
import org.gcube.application.speciesmanager.stubs.util.Util;
import org.gcube.application.speciesmanager.stubs.writers.AbstractWrapper;
import org.gcube.application.speciesmanager.stubs.writers.OccurrenceWriter;
import org.gcube.application.speciesmanager.stubs.writers.RSWrapper;
import org.gcube.application.speciesmanager.transport.LocalReader;
import org.gcube.application.speciesmanager.transport.LocalWrapper;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.tools.PointsMapCreator;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;

public class OccurrencesPT
extends GCUBEPortType {
    GCUBELog logger = new GCUBELog(OccurrencesPT.class);

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public String getByIds(String keysLocator) throws Exception {
        final StringReader reader = new StringReader(keysLocator);
        final RSWrapper wrapper = new RSWrapper(ServiceContext.getContext().getScope());
        final GCUBEScope scope = ServiceContext.getContext().getScope();
        new Thread(){

            @Override
            public void run() {
                ArrayList<String> idsList = new ArrayList<String>();
                String previousPlugin = "";
                while (reader.hasNext()) {
                    String key = (String)reader.next();
                    String pluginName = Util.getProviderFromKey((String)key);
                    String id = Util.getIdFromKey((String)key);
                    if (pluginName.equals(previousPlugin) || previousPlugin.equals("")) {
                        idsList.add(id);
                        previousPlugin = pluginName;
                        continue;
                    }
                    OccurrencesPT.this.logger.trace((Object)("grouped " + idsList.size() + " ids for plugin " + previousPlugin + " in scope " + scope));
                    new OccurrencesThread(previousPlugin, wrapper, idsList.toArray(new String[idsList.size()]), scope).start();
                    previousPlugin = pluginName;
                    idsList = new ArrayList();
                    idsList.add(id);
                }
                if (idsList.size() > 0) {
                    OccurrencesPT.this.logger.trace((Object)("grouped " + idsList.size() + " ids for plugin " + previousPlugin));
                    new OccurrencesThread(previousPlugin, wrapper, idsList.toArray(new String[idsList.size()]), scope).start();
                }
            }
        }.start();
        return wrapper.getLocator().toString();
    }

    public String getLayerByIds(String keysLocator) throws Exception {
        TSGeoToolsConfiguration configuration = new TSGeoToolsConfiguration();
        configuration.setConfigPath((String)ServiceContext.getContext().getProperty("configDir", new boolean[]{true}));
        configuration.setGeoServerDatabase("jdbc:postgresql://geoserver-test.d4science-ii.research-infrastructures.eu/timeseriesgisdb");
        configuration.setGeoServerUserName("postgres");
        configuration.setGeoServerPassword("d4science2");
        GISInformation gisInfo = new GISInformation();
        gisInfo.setGeoNetworkUrl("http://geoserver-dev.d4science-ii.research-infrastructures.eu:8080/geonetwork");
        gisInfo.setGeoNetworkUserName("admin");
        gisInfo.setGeoNetworkPwd("admin");
        gisInfo.setGisDataStore("timeseriesgisdb");
        gisInfo.setGisPwd("gcube@geo2010");
        gisInfo.setGisWorkspace("aquamaps");
        gisInfo.setGisUrl("http://geoserver-dev.d4science-ii.research-infrastructures.eu:8080/geoserver");
        gisInfo.setGisUserName("admin");
        this.logger.info((Object)"GIS configuration finished");
        ArrayList<Tuple> xyPoints = new ArrayList<Tuple>();
        final StringReader reader = new StringReader(keysLocator);
        final LocalWrapper wrapper = new LocalWrapper();
        final GCUBEScope scope = ServiceContext.getContext().getScope();
        new Thread(){

            @Override
            public void run() {
                HashMap<String, OccurrenceWriter> mapPluginWriter = new HashMap<String, OccurrenceWriter>();
                while (reader.hasNext()) {
                    OccurrenceWriter writer;
                    String key = (String)reader.next();
                    String pluginName = Util.getProviderFromKey((String)key);
                    String id = Util.getIdFromKey((String)key);
                    if (mapPluginWriter.containsKey(pluginName)) {
                        writer = (OccurrenceWriter)mapPluginWriter.get(pluginName);
                    } else {
                        writer = new OccurrenceWriter((AbstractWrapper)wrapper, pluginName);
                        mapPluginWriter.put(pluginName, writer);
                    }
                    try {
                        PluginManager.get(scope).plugins().get(pluginName).getOccurrencesInterface().getOccurrencesById((ObjectWriter)writer, new String[]{id});
                    }
                    catch (Exception e) {
                        OccurrencesPT.this.logger.error((Object)("error retrieving id " + id + " from " + pluginName));
                    }
                }
                for (OccurrenceWriter w : mapPluginWriter.values()) {
                    w.close();
                }
            }
        }.start();
        LocalReader localReader = new LocalReader(wrapper.getLocator());
        int totalRecordSent = 0;
        while (localReader.hasNext()) {
            Occurrence occurrence = Bindings.occurrencefromXml((String)localReader.next());
            xyPoints.add(new Tuple((Object[])new Float[]{Float.valueOf((float)occurrence.getDecimalLongitude()), Float.valueOf((float)occurrence.getDecimalLatitude())}));
            ++totalRecordSent;
        }
        this.logger.trace((Object)("total record sent " + totalRecordSent));
        PointsMapCreator pmcreator = new PointsMapCreator(configuration);
        String destinationMapTable = "occ" + UUID.randomUUID().toString().replace("-", "");
        String destinationMapName = "occurrence points";
        String groupCreated = pmcreator.createMapFromPoints(xyPoints, destinationMapTable, destinationMapName, gisInfo);
        this.logger.info((Object)("gis tabel is " + destinationMapTable + " and groupId " + groupCreated));
        return groupCreated;
    }

    class OccurrencesThread
    extends Thread {
        private String plugin;
        private String[] ids;
        private RSWrapper wrapper;
        private GCUBEScope scope;

        public OccurrencesThread(String plugin, RSWrapper wrapper, String[] ids, GCUBEScope scope) {
            this.plugin = plugin;
            this.ids = ids;
            this.wrapper = wrapper;
            this.scope = scope;
        }

        @Override
        public void run() {
            try {
                OccurrenceWriter writer = new OccurrenceWriter((AbstractWrapper)this.wrapper, this.plugin);
                PluginManager.get(this.scope).plugins().get(this.plugin).getOccurrencesInterface().getOccurrencesById((ObjectWriter)writer, this.ids);
                writer.close();
            }
            catch (Exception e) {
                OccurrencesPT.this.logger.error((Object)("error retrieving ids from " + this.plugin), (Throwable)e);
            }
        }
    }
}

