package org.gcube.application.speciesmanager.stubs.model;

import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import static org.gcube.data.trees.data.Nodes.e;
import static org.gcube.data.trees.data.Nodes.t;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Labels;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Tree;

@XmlRootElement
@XmlAccessorType(XmlAccessType.NONE)
public class Taxon {

	@XmlAttribute(required=true)
	private String id;
	@XmlAttribute
	private String rank;
	@XmlAttribute
	private String scientificName;
	@XmlAttribute
	private String citation;
	@XmlElement
	protected Taxon parent = null;
	
	protected Taxon(){}
	
	public Taxon(String id){
		this.id = id;
	}
	
	public Taxon(String id, String scientificName){
		this.id = id;
		this.scientificName = scientificName;
	}
	
	public void setRank(String rank) {
		this.rank = rank;
	}

	public String getScientificName() {
		return scientificName;
	}

	public void setScientificName(String scientificName) {
		this.scientificName = scientificName;
	}

	public String getCitation() {
		return citation;
	}

	public void setCitation(String citation) {
		this.citation = citation;
	}

	public String getId() {
		return id;
	}
	
	public String getRank() {
		return rank;
	}

	public Taxon getParent() {
		return parent;
	}

	public void setParent(Taxon parent) {
		this.parent = parent;
	}

	protected Tree node(){
		Tree node = t(this.id);
		if (parent!=null) node.add(e(Labels.PARENT_TAG,this.parent.node()));
		node.add(e(Labels.CITATION_LABEL, this.getCitation()));
		node.add(e(Labels.SCIENTIFICNAME_LABEL, this.getScientificName()));
		node.add(e(Labels.RANK_LABEL, this.getRank()));
		return node;
	}
	
	protected static Taxon fromNode(InnerNode node) throws Exception{
		Taxon taxon = new Taxon(node.id());
		for (Field field: Taxon.class.getDeclaredFields())
			if (node.hasEdge(field.getName()) && (node.edge(field.getName()).target() instanceof Leaf)){
				field.setAccessible(true);
				field.set(taxon, ((Leaf) node.edge(field.getName()).target()).value());
			}
		if (node.hasEdge(Labels.PARENT_TAG))
			taxon.parent = Taxon.fromNode((InnerNode)node.child(Labels.PARENT_TAG));

		return taxon;
	}
	
	public String toString(){
		StringBuilder toReturn= new StringBuilder();
		toReturn.append("[id: "+id+"]");
		toReturn.append("[scientificName :"+scientificName+"]");
		toReturn.append("[citation: "+citation+"]");
		toReturn.append("[rank: "+rank+"]");
		if (parent!=null)toReturn.append("[parent taxon: "+parent+"]");
		return toReturn.toString();
	}
}
