package org.gcube.application.speciesmanager.stubs.model.binding;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXBContext;

import org.gcube.application.speciesmanager.stubs.model.Occurrence;
import org.gcube.application.speciesmanager.stubs.model.ResultItem;

public class Bindings {

	
	public static ResultItem resultItemfromXml(String xml) throws Exception{
		JAXBContext context = JAXBContext.newInstance(ResultItem.class);
		return (ResultItem)context.createUnmarshaller().unmarshal(new StringReader(xml));
	}
	
	public static Occurrence occurrencefromXml(String xml) throws Exception{
		JAXBContext context = JAXBContext.newInstance(Occurrence.class);
		return (Occurrence)context.createUnmarshaller().unmarshal(new StringReader(xml));
	}
	
	public static String toXml(ResultItem item) throws Exception{
		JAXBContext context = JAXBContext.newInstance(ResultItem.class);
		StringWriter sw = new StringWriter();
		context.createMarshaller().marshal(item, sw);
		return sw.toString();
	}

	public static String toXml(Occurrence item) throws Exception{
		JAXBContext context = JAXBContext.newInstance(Occurrence.class);
		StringWriter sw = new StringWriter();
		context.createMarshaller().marshal(item, sw);
		return sw.toString();
	}
}
