package org.gcube.application.speciesmanager.stubs.writers;

import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class AbstractWriter<T> implements ObjectWriter<T>{
		
	private GCUBELog logger= new GCUBELog(AbstractWriter.class);
	
	private boolean closed;
	
	private AbstractWrapper wrapper;
	
	protected AbstractWriter(AbstractWrapper wrapper) {
		this.wrapper = wrapper;
		this.wrapper.register();
	}

	protected AbstractWrapper getWrapper() {
		return wrapper;
	}

	public void close() {
		try {
			if (!closed){
				this.wrapper.unregister();
				closed=true;
			}
		} catch (Exception e) {
			logger.error("error closing writer",e);
		}
	}
	
	
}
