package org.gcube.application.speciesmanager.stubs.writers;



import org.gcube.application.speciesmanager.stubs.model.Product;
import org.gcube.application.speciesmanager.stubs.model.ResultItem;
import org.gcube.application.speciesmanager.stubs.model.binding.Bindings;
import org.gcube.application.speciesmanager.stubs.util.Util;
import org.gcube.common.core.utils.logging.GCUBELog;



public class ResultItemWriter extends AbstractWriter<ResultItem>{

	private GCUBELog logger= new GCUBELog(ResultItemWriter.class);
	
	private String repositoryProvider;

	
	
	public ResultItemWriter(RSWrapper wrapper, String repositoryProvider) {
		super(wrapper);
		this.repositoryProvider = repositoryProvider;
	}
	
	@Override
	public boolean put(ResultItem t) {
		try{
			t.setProvider(repositoryProvider);
			if (t.getProducts()!=null)
				for (Product prod: t.getProducts())
					prod.setKey(Util.keyEnrichment(repositoryProvider, prod.getKey()));
			return getWrapper().add(Bindings.toXml(t));
		}catch (Exception e) {
			logger.error("error putting the object",e);
			return false;
		}
	}

	

	

}
