/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.stubs.calls;

import com.thoughtworks.xstream.XStream;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.speciesmanager.stubs.ManagerPortType;
import org.gcube.application.speciesmanager.stubs.SearchByCommonNameRequest;
import org.gcube.application.speciesmanager.stubs.SearchByScientificNameRequest;
import org.gcube.application.speciesmanager.stubs.calls.Call;
import org.gcube.application.speciesmanager.stubs.model.ResultItem;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Property;
import org.gcube.application.speciesmanager.stubs.readers.ResultItemReader;
import org.gcube.application.speciesmanager.stubs.service.ManagerServiceAddressingLocator;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;

public class ManagerCalls
extends Call {
    private ManagerPortType managerPT;
    private GCUBEScope scope;

    public ManagerCalls(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        this.scope = scope;
        this.managerPT = new ManagerServiceAddressingLocator().getManagerPortTypePort(this.getEPR());
        this.managerPT = (ManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)this.managerPT, (GCUBEScope)scope, (GCUBESecurityManager[])securityManager);
    }

    protected String getPortTypeName() {
        return "gcube/application/speciesmanager/manager";
    }

    private EndpointReferenceType getEPR() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", this.getServiceName()), new AtomicCondition("//ServiceClass", this.getServiceClass())});
        List ris = client.execute((ISQuery)query, this.scope);
        if (ris.size() > 0) {
            return ((GCUBERunningInstance)ris.get(0)).getAccessPoint().getEndpoint(this.getPortTypeName());
        }
        throw new Exception("EPR not found, the service is not ready");
    }

    public Iterator<ResultItem> searchByScientificName(String scientificName, Property ... props) throws Exception {
        ArrayList<String> properties = new ArrayList<String>();
        if (props != null && props.length > 0) {
            XStream xstream = new XStream();
            Property[] propertyArray = props;
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                Property prop = propertyArray[n2];
                properties.add(xstream.toXML((Object)prop));
                ++n2;
            }
        }
        return new ResultItemReader(this.managerPT.searchByScientificName(new SearchByScientificNameRequest(null, properties.toArray(new String[0]), scientificName)));
    }

    public Iterator<ResultItem> searchByCommonName(String commonName, Property ... props) throws Exception {
        ArrayList<String> properties = new ArrayList<String>();
        if (props != null && props.length > 0) {
            XStream xstream = new XStream();
            Property[] propertyArray = props;
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                Property prop = propertyArray[n2];
                properties.add(xstream.toXML((Object)prop));
                ++n2;
            }
        }
        return new ResultItemReader(this.managerPT.searchByCommonName(new SearchByCommonNameRequest(commonName, null, properties.toArray(new String[0]))));
    }
}

