package org.gcube.application.framework.harvesting.tree;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

//@WebServlet("/HarvestTrees")
public class HarvestTrees extends HttpServlet {

	private static final long serialVersionUID = 1L;
	
	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(HarvestTrees.class);
	
    public HarvestTrees() {
        super();
    }


	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException{
		PrintWriter out = response.getWriter();
		
		String collectionID = request.getParameter("treeCollectionID");
		String scope = request.getParameter("scope");
		String collectionName = request.getParameter("treeCollectionName");
		String queued = request.getParameter("queued");
		
		logger.debug("Requested tree collection:\t"+collectionID);

		TCollectionReader treeCollectionReader;
		if(collectionName == null)
			treeCollectionReader = new TCollectionReader(collectionID, scope);
		else
			treeCollectionReader = new TCollectionReader(collectionID, scope, collectionName);
		if("true".equalsIgnoreCase(queued)) //if user provides queued=true
			treeCollectionReader.readPrintCollectionsQueued2(response.getWriter());
		else {//default case, not queued
			treeCollectionReader.readPrintCollections(response.getWriter());
		}
		out.close();

	}


	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
	}
	
	
	
	
	
}
