/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.content.access;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailViewer
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ThumbnailViewer.class);
    private static final long serialVersionUID = 1L;
    private static final String operationID = "GetThumbnails";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        try {
            String oid = request.getParameter("OID");
            String documentUri = request.getParameter("documentURI");
            int width = Integer.parseInt(request.getParameter("width"));
            int height = Integer.parseInt(request.getParameter("height"));
            String options = request.getParameter("options");
            ServletOutputStream out = response.getOutputStream();
            ASLSession aslSession = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
            DigitalObject digObj = null;
            digObj = documentUri == null || documentUri.equals("") ? new DigitalObject(aslSession, oid, null) : new DigitalObject(aslSession, documentUri);
            String mime = "image/png";
            String name = digObj.getCollectionName();
            response.addHeader("content_name", name);
            response.setContentType(mime);
            logger.info("Thumbnail successfully received!");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            response.setContentType("unknown/unknown");
            logger.error("Exception:", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

