/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.harvesting.db;

import com.google.inject.Singleton;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.harvesting.common.ElementGenerator;
import org.gcube.application.framework.harvesting.common.HarversterDBServiceAPI;
import org.gcube.application.framework.harvesting.common.db.exceptions.SourceIDNotFoundException;
import org.gcube.application.framework.harvesting.common.db.is.ISResources;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.db.xmlobjects.DBProps;
import org.gcube.application.framework.harvesting.common.db.xmlobjects.DBSource;
import org.gcube.application.framework.harvesting.common.db.xmlobjects.Table;
import org.gcube.application.framework.harvesting.db.DBDataStax;
import org.gcube.application.framework.harvesting.db.resources.DBPropsFactory;
import org.gcube.application.framework.harvesting.db.toolbox.GenericTools;
import org.gcube.rest.commons.filter.IResourceFilter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.gcube.rest.resourceawareservice.ResourceAwareService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceAwareServiceException;
import org.gcube.rest.resourcemanager.discoverer.Discoverer;
import org.gcube.rest.resourcemanager.discoverer.exceptions.DiscovererException;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/")
@Singleton
public class HarvestDB
extends ResourceAwareService<DBProps>
implements HarversterDBServiceAPI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(HarvestDB.class);
    private final Discoverer<DBProps> dbPropsDiscoverer;
    private final DBPropsFactory dbPropsFactory;
    private final ResourcePublisher<DBProps> dbPropsPublisher;
    private String scope;
    final String hostname;
    final String port;

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.scope != null) {
            throw new IllegalStateException("scope already set");
        }
        this.scope = scope;
    }

    public HarvestDB(DBPropsFactory dbPropsFactory, ResourcePublisher<DBProps> dbPropsPublisher, Discoverer<DBProps> dbPropsDiscoverer, IResourceFilter<DBProps> resourceFilter, IResourceFileUtils<DBProps> resourceFileUtils, String hostname, String port) throws ResourceAwareServiceException {
        super((ResourceFactory)dbPropsFactory, dbPropsPublisher, resourceFilter, resourceFileUtils);
        this.dbPropsFactory = dbPropsFactory;
        this.dbPropsPublisher = dbPropsPublisher;
        this.dbPropsDiscoverer = dbPropsDiscoverer;
        this.hostname = hostname;
        this.port = port;
        logger.info("In HarvestDB constructor");
    }

    public String getResourceClass() {
        return "HarvesterResource";
    }

    public String getResourceNamePref() {
        return "DBResource";
    }

    @GET
    @Path(value="/AvailableResources")
    @Produces(value={"application/xml; charset=UTF-8"})
    public Response AvailableResources() throws ParserConfigurationException, TransformerException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element rootElement = doc.createElement("Resources");
        for (DBProps dbProps : this.getAllResources()) {
            Element resource = doc.createElement("resource");
            Element resourceid = doc.createElement("resourceid");
            resourceid.appendChild(doc.createTextNode(dbProps.getResourceID()));
            Element sourcename = doc.createElement("sourcename");
            sourcename.appendChild(doc.createTextNode(dbProps.getSourceName()));
            Element propsname = doc.createElement("propsname");
            propsname.appendChild(doc.createTextNode(dbProps.getPropsName()));
            resource.appendChild(resourceid);
            resource.appendChild(sourcename);
            resource.appendChild(propsname);
            rootElement.appendChild(resource);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ElementGenerator.domToXML((Element)rootElement)).build();
    }

    @POST
    @Path(value="/DeleteAllDBHarvesterConfigs")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response DeleteAllDBHarvesterConfigs(@HeaderParam(value="gcube-scope") String scopeHeader) throws SourceIDNotFoundException, Exception {
        for (DBProps dbp : this.getAllResources()) {
            this.destroyResource(dbp.getResourceID());
            logger.debug("Deleted resource with ID: " + dbp.getResourceID() + " and name: " + dbp.getPropsName());
        }
        return Response.status((int)201).entity((Object)"Deleted all resources").build();
    }

    @POST
    @Path(value="/ReplaceDBHarvesterConfig")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response ReplaceDBHarvesterConfig(@HeaderParam(value="gcube-scope") String scopeHeader, @FormParam(value="dbPropsXML") String dbPropsXML) throws SourceIDNotFoundException, Exception {
        DBProps dbProps = SourcePropsTools.parseSourceProps((String)dbPropsXML);
        this.RemoveDBHarvesterConfig(scopeHeader, dbProps.getPropsName());
        this.CreateDBHarvesterConfig(scopeHeader, dbPropsXML);
        return Response.status((int)201).entity((Object)"Loaded successfully config file").build();
    }

    @POST
    @Path(value="/CreateDBHarvesterConfig")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response CreateDBHarvesterConfig(@HeaderParam(value="gcube-scope") String scopeHeader, @FormParam(value="dbPropsXML") String dbPropsXML) throws SourceIDNotFoundException, Exception {
        if (dbPropsXML == null) {
            return Response.status((int)400).entity((Object)"Parameter dbPropsXML is missing!").build();
        }
        boolean exists = false;
        DBProps dbProps = SourcePropsTools.parseSourceProps((String)dbPropsXML);
        for (DBProps dbp : this.getAllResources()) {
            if (!dbp.getPropsName().equals(dbProps.getPropsName())) continue;
            exists = true;
            logger.debug("Provided resource with propsname " + dbProps.getPropsName() + " already exists. Will not create the resource.");
            return Response.status((int)200).entity((Object)("Provided resource with propsname " + dbProps.getPropsName() + " already exists. Will not create the resource.")).build();
        }
        if (!exists) {
            String resourceID = this.createResource(dbPropsXML);
            logger.debug("created resource with id: " + resourceID);
            return Response.status((int)201).entity((Object)"Created successfully config file").build();
        }
        return Response.status((int)200).build();
    }

    @POST
    @Path(value="/RemoveDBHarvesterConfig")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response RemoveDBHarvesterConfig(@HeaderParam(value="gcube-scope") String scopeHeader, @FormParam(value="propsname") String propsname) throws StatefulResourceException, DiscovererException {
        if (propsname == null) {
            return Response.status((int)400).entity((Object)"Parameter \"propsname\" is missing!").build();
        }
        for (DBProps dbProps : this.getAllResources()) {
            if (!dbProps.getSourceType().equals("RelationalDB") || !dbProps.getPropsName().equals(propsname)) continue;
            this.destroyResource(dbProps.getResourceID());
        }
        return Response.status((int)201).entity((Object)"Removed successfully config file").build();
    }

    @GET
    @Path(value="/HarvestDatabase")
    @Produces(value={"text/xml; charset=UTF-8"})
    public Response HarvestDatabase(@HeaderParam(value="gcube-scope") String scopeHeader, @QueryParam(value="sourcename") String sourcename, @QueryParam(value="propsname") String propsname, @QueryParam(value="recordid") String recordid) throws Exception {
        DBSource dbSource = ISResources.getDBSourceInfo((String)sourcename, (String)scopeHeader);
        DBProps dbProps = null;
        List resources = this.getAllResources();
        if (resources.size() == 0) {
            return Response.status((int)404).entity((Object)("Could not find any database configuration file stored for database named " + sourcename)).build();
        }
        if (resources.size() == 1) {
            dbProps = (DBProps)resources.get(0);
        } else if (resources.size() > 1) {
            for (DBProps dbp : resources) {
                if (!dbp.getPropsName().equalsIgnoreCase(propsname)) continue;
                dbProps = dbp;
            }
        }
        if (!GenericTools.mergeableProperties((DBSource)dbSource, (DBProps)dbProps)) {
            String response = "Sourcename property mismatch between db credentials file and db configuration file: " + dbSource.getSourceName() + " vs " + dbProps.getSourceName();
            return Response.status((int)500).entity((Object)response).build();
        }
        String validityStr = SourcePropsTools.isValid((DBProps)dbProps);
        if (!validityStr.equals("valid")) {
            return Response.status((int)500).entity((Object)validityStr).build();
        }
        logger.debug("All properties seem to be finely set, fetching the results from the DB");
        DBDataStax dbDataStax = new DBDataStax(dbSource, dbProps, scopeHeader);
        if (recordid != null && !recordid.isEmpty()) {
            dbDataStax = this.filterRootSqlBy(dbDataStax, recordid);
        }
        StreamingOutput outputStream = dbDataStax.writeSourceData(this.hostname + ":" + this.port);
        return Response.ok((Object)outputStream).build();
    }

    private DBDataStax filterRootSqlBy(DBDataStax dbDataStax, String recordid) {
        for (int i = 0; i < dbDataStax.getSourceProps().getTables().size(); ++i) {
            int k;
            if (!((Table)dbDataStax.getSourceProps().getTables().get(i)).getName().equalsIgnoreCase(dbDataStax.getRootTableName())) continue;
            String tableName = ((Table)dbDataStax.getSourceProps().getTables().get(i)).getName();
            String sql = ((Table)dbDataStax.getSourceProps().getTables().get(i)).getSql();
            String[] keys = SourcePropsTools.getPKeyOfTable((DBProps)dbDataStax.getSourceProps(), (String)tableName).split(",");
            String[] keysVals = recordid.split(",");
            if (sql.toLowerCase().contains(" where ")) {
                for (k = 0; k < keys.length; ++k) {
                    sql = sql + " and " + keys[k] + "='" + keysVals[k] + "'";
                }
                ((Table)dbDataStax.getSourceProps().getTables().get(i)).setSql(sql);
                continue;
            }
            sql = sql + " where " + keys[0] + "='" + keysVals[0] + "'";
            for (k = 1; k < keys.length; ++k) {
                sql = sql + " and " + keys[k] + "='" + keysVals[k] + "'";
            }
            ((Table)dbDataStax.getSourceProps().getTables().get(i)).setSql(sql);
        }
        return dbDataStax;
    }
}

