/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.datatransformation.util;

import java.net.URI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.application.framework.contentmanagement.datatransformation.util.DataTransformationUtils;
import org.gcube.application.framework.contentmanagement.exceptions.ContentReaderCreationException;
import org.gcube.application.framework.contentmanagement.exceptions.OCRException;
import org.gcube.application.framework.contentmanagement.exceptions.ReadingRSException;
import org.gcube.application.framework.contentmanagement.exceptions.ServiceEPRRetrievalException;
import org.gcube.application.framework.contentmanagement.exceptions.TransformationException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.execution.ocrservice.stubs.InputResource;
import org.gcube.execution.ocrservice.stubs.OCRServiceFactoryPortType;
import org.gcube.execution.ocrservice.stubs.OCRServicePortType;
import org.gcube.execution.ocrservice.stubs.StatusResponseType;
import org.gcube.execution.ocrservice.stubs.Submit;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceAddressingLocator;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceFactoryServiceAddressingLocator;
import org.gcube.informationsystem.cache.SrvType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDTSClient {
    private static final Logger logger = LoggerFactory.getLogger(TestDTSClient.class);

    public static void main(String[] args) {
        try {
            ArrayList<String> colid = new ArrayList<String>();
            colid.add("");
            String resultsEpr = DataTransformationUtils.transformPDFDocumentsToText("dl10.di.uoa.gr:8181/documentLocations.txt", colid, "testpdfcol", "gcube/devNext");
            ArrayList<String> wrong = new ArrayList<String>();
            ArrayList<DocumentInfos> failures = DataTransformationUtils.getReports(resultsEpr, wrong);
            TestDTSClient.performOCRtoPDF_HTTPInput(failures, colid.get(0), "/gcube/devNext");
        }
        catch (ServiceEPRRetrievalException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (TransformationException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (ReadingRSException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (OCRException e) {
            logger.error("Exception:", (Throwable)e);
        }
    }

    public static ArrayList<String> performOCRtoPDF_HTTPInput(ArrayList<DocumentInfos> documents, String outputCollectionId, String scope) throws ServiceEPRRetrievalException, OCRException {
        ArrayList<String> HocrOutputSSIDs = new ArrayList<String>();
        String ocrEPR = TestDTSClient.getOCRServiceEPR("/gcube/devNext");
        EndpointReferenceType factoryEPR = new EndpointReferenceType();
        try {
            factoryEPR.setAddress((AttributedURI)new Address(ocrEPR));
        }
        catch (URI.MalformedURIException e) {
            logger.error("Exception:", (Throwable)e);
            throw new ServiceEPRRetrievalException(e);
        }
        OCRServiceFactoryPortType stub = null;
        try {
            stub = new OCRServiceFactoryServiceAddressingLocator().getOCRServiceFactoryPortTypePort(factoryEPR);
            stub = (OCRServiceFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)stub, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (ServiceException e) {
            logger.error("Exception:", (Throwable)e);
            throw new ServiceEPRRetrievalException(e);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new ServiceEPRRetrievalException(e);
        }
        int numDocs = 0;
        for (int i = 0; i < documents.size(); ++i) {
            OCRServicePortType stub2;
            InputResource input = new InputResource();
            logger.info("Printing...");
            if (documents.get(i) == null) {
                logger.info("IT IS NULL " + documents.size());
            }
            logger.info("The document id is: " + documents.get(i).getDocumentId() + " " + documents.get(i).getPdfURI());
            input.setResourceKey(documents.get(i).getDocumentId().trim());
            input.setResourceAccess("Reference");
            input.setResourceReference(documents.get(i).getPdfURI().trim());
            Submit sub = new Submit();
            sub.setInputResource(input);
            EndpointReferenceType resourceEPR = null;
            try {
                resourceEPR = stub.submit(sub).getEndpointReference();
            }
            catch (GCUBEUnrecoverableFault e) {
                logger.error("Exception:", (Throwable)e);
                throw new ServiceEPRRetrievalException(e);
            }
            catch (RemoteException e) {
                logger.error("Exception:", (Throwable)e);
                throw new ServiceEPRRetrievalException(e);
            }
            try {
                stub2 = new OCRServiceAddressingLocator().getOCRServicePortTypePort(resourceEPR);
                stub2 = (OCRServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)stub2, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            }
            catch (ServiceException e) {
                logger.error("Exception:", (Throwable)e);
                throw new ServiceEPRRetrievalException(e);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
                throw new ServiceEPRRetrievalException(e);
            }
            StatusResponseType status = null;
            do {
                try {
                    status = stub2.status(new VOID());
                    Thread.sleep(10000L);
                }
                catch (GCUBEUnrecoverableFault e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (RemoteException e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.error("Exception:", (Throwable)e);
                }
            } while (!status.isCompleted());
            logger.info("Number of documents transformed: " + ++numDocs);
            HocrOutputSSIDs.add(status.getHocrOutputSSID());
            String error = status.getJoberrSSID();
            logger.info("The JOBERRSSID is: " + error);
        }
        DocumentWriter cmWriter = null;
        DocumentReader cmReader = null;
        GCubeDocument doc = null;
        try {
            boolean first = true;
            cmWriter = new DocumentWriter(outputCollectionId, GCUBEScope.getScope((String)scope));
            logger.info(String.valueOf(HocrOutputSSIDs.size()));
            for (int i = 0; i < HocrOutputSSIDs.size(); ++i) {
                if (HocrOutputSSIDs.get(i) == null) {
                    logger.info("CRY");
                } else {
                    logger.info("CRY NOT");
                }
                URI theUri = new URI(HocrOutputSSIDs.get(i).trim());
                String oid = URIs.documentID((URI)theUri);
                String colID = URIs.collectionID((URI)theUri);
                if (!first) continue;
                try {
                    cmReader = new DocumentReader(colID, GCUBEScope.getScope((String)scope));
                    cmWriter = new DocumentWriter(outputCollectionId, GCUBEScope.getScope((String)scope));
                }
                catch (Exception e) {
                    logger.error("Exception:", (Throwable)e);
                    throw new ContentReaderCreationException(e);
                }
                doc = cmReader.get(oid, (Projection)Projections.document());
                String myNewDocumentId = cmWriter.add(doc);
            }
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new OCRException(e);
        }
        return HocrOutputSSIDs;
    }

    private static String getOCRServiceEPR(String scope) {
        EndpointReference[] ocrService = null;
        logger.info("Looking for an OCRService epr");
        try {
            ocrService = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("Execution", "OCRService", SrvType.FACTORY.name());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        logger.info("The ocrService epr is NULL");
        return "http://dl20.di.uoa.gr:8485/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory";
    }
}

