/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.util;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.gcube.application.framework.contentmanagement.exceptions.ViewPublishingException;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewManagementUtils {
    private static final Logger logger = LoggerFactory.getLogger(ViewManagementUtils.class);

    public static String createMetadataView(String collectionId, String name, String description, String schemaName, Locale schemaLanguage, String schemaURI, ASLSession session) throws ViewPublishingException {
        MetadataView view = new MetadataView(session.getScope());
        view.setCollectionId(collectionId);
        view.setName(name);
        view.setDescription(description);
        try {
            view.setProjection(schemaLanguage, schemaName, new URI(schemaURI));
            try {
                view.publish();
                return view.id();
            }
            catch (GCUBEException e) {
                throw new ViewPublishingException(e);
            }
            catch (IllegalStateException e) {
                throw new ViewPublishingException(e);
            }
            catch (Exception e) {
                throw new ViewPublishingException(e);
            }
        }
        catch (URISyntaxException e) {
            throw new ViewPublishingException(e);
        }
    }

    public static void addGCubeMetadataForDocument(String documentId, String collectionId, String schemaName, Locale schemaLanguage, String schemaURI, InputStream payload, ASLSession session) {
        GCubeMetadata meta = new GCubeMetadata();
        try {
            meta.setSchemaName(schemaName);
            meta.setLanguage(schemaLanguage);
            meta.setSchemaURI(new URI(schemaURI));
            meta.setBytestream(payload);
            DocumentWriter cmWriter = new DocumentWriter(collectionId, session.getScope());
            DocumentReader cmReader = new DocumentReader(collectionId, session.getScope());
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp);
            document.metadata().add((BaseInnerElement)meta);
            cmWriter.update(document);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
    }
}

