/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.datatransformation.util;

import java.util.ArrayList;
import org.apache.axis.message.addressing.EndpointReference;
import org.gcube.application.framework.contentmanagement.datatransformation.util.DataTransformationUtils;
import org.gcube.application.framework.contentmanagement.exceptions.OCRException;
import org.gcube.application.framework.contentmanagement.exceptions.ReadingRSException;
import org.gcube.application.framework.contentmanagement.exceptions.ServiceEPRRetrievalException;
import org.gcube.application.framework.contentmanagement.exceptions.TransformationException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.informationsystem.cache.SrvType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDTSClient {
    private static final Logger logger = LoggerFactory.getLogger(TestDTSClient.class);

    public static void main(String[] args) {
        try {
            ArrayList<String> colid = new ArrayList<String>();
            colid.add("");
            String resultsEpr = DataTransformationUtils.transformPDFDocumentsToText("dl10.di.uoa.gr:8181/documentLocations.txt", colid, "testpdfcol", "gcube/devNext");
            ArrayList<String> wrong = new ArrayList<String>();
            ArrayList<DocumentInfos> failures = DataTransformationUtils.getReports(resultsEpr, wrong);
            TestDTSClient.performOCRtoPDF_HTTPInput(failures, colid.get(0), "/gcube/devNext");
        }
        catch (ServiceEPRRetrievalException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (TransformationException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (ReadingRSException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (OCRException e) {
            logger.error("Exception:", (Throwable)e);
        }
    }

    public static ArrayList<String> performOCRtoPDF_HTTPInput(ArrayList<DocumentInfos> documents, String outputCollectionId, String scope) throws ServiceEPRRetrievalException, OCRException {
        return new ArrayList<String>();
    }

    private static String getOCRServiceEPR(String scope) {
        EndpointReference[] ocrService = null;
        logger.info("Looking for an OCRService epr");
        try {
            ocrService = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("Execution", "OCRService", SrvType.FACTORY.name());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        logger.info("The ocrService epr is NULL");
        return "http://dl20.di.uoa.gr:8485/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory";
    }
}

