/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.cache.factories;

import java.util.Iterator;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.gcube.application.framework.contentmanagement.model.CollectionInfo;
import org.gcube.application.framework.contentmanagement.util.XMLTokenReplacer;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionInfoCacheEntryFactory
implements CacheEntryFactory {
    static ISClient client = null;
    private static final String IS_NAMESPACE_DECL = "declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry';\n";
    public static final String VIEWMANAGER = "ViewManager";
    public static final String XP_ISUSER = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='isUserCollection']/child::*[local-name()='value']/text()";
    public static final String FACTORYID = "factory";
    public static final String XP_SCHEMANAME = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='schemaName']/child::*[local-name()='value']/text()";
    public static final String XP_LANGUAGE = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='language']/child::*[local-name()='value']/text()";
    public static final String XP_COLNAME = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='name']/child::*[local-name()='value']/text()";
    public static final String XP_COLID = "//child::*[local-name()='id']/text()";
    public static final String XP_RELATEDCOLID = "//child::*[local-name()='collectionID']/text()";
    public static final String XP_SCHEMAURI = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='schemaURI']/child::*[local-name()='value']/text()";
    private static final Logger logger = LoggerFactory.getLogger(CollectionInfoCacheEntryFactory.class);

    public CollectionInfoCacheEntryFactory() {
        if (client == null) {
            try {
                client = (ISClient)GHNContext.getImplementation(ISClient.class);
            }
            catch (Exception e) {
                logger.error("Failed to get implemetation of ISClient", (Throwable)e);
            }
        }
    }

    public Object createEntry(Object key) throws Exception {
        QueryString query = (QueryString)key;
        String colId = (String)query.get((Object)"colId");
        String scope = (String)query.get((Object)"scope");
        return this.harvestCollectionProfile(colId, scope);
    }

    public CollectionInfo harvestCollectionProfile(String colId, String scope) throws GCUBEScope.MalformedScopeExpressionException, ISClient.ISMalformedQueryException, ISClient.ISUnsupportedQueryException, ISException, XMLResult.ISResultEvaluationException {
        WSResourceQuery wsquery = null;
        try {
            wsquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        }
        catch (ISClient.ISUnsupportedQueryException e1) {
            logger.error("Exception:", (Throwable)e1);
        }
        catch (InstantiationException e1) {
            logger.error("Exception:", (Throwable)e1);
        }
        catch (IllegalAccessException e1) {
            logger.error("Exception:", (Throwable)e1);
        }
        wsquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//child::*[local-name()='ServiceName']", VIEWMANAGER)});
        CollectionInfo colInfo = new CollectionInfo();
        colInfo.setId(colId);
        logger.debug("===SOMetadataCollections===");
        for (RPDocument rpd : client.execute((ISQuery)wsquery, GCUBEScope.getScope((String)scope))) {
            logger.trace("Found View with ID: " + rpd.getKey().getValue());
            if (rpd.getKey().getValue().trim().equalsIgnoreCase(FACTORYID)) continue;
            logger.trace("Not factory");
            String userCollection = "false";
            for (String value : rpd.evaluate(XP_ISUSER)) {
                userCollection = value.trim();
            }
            logger.trace("userCollection: " + userCollection);
            if (userCollection.equalsIgnoreCase("false")) continue;
            logger.trace("User View");
            String MColID = null;
            String MColName = null;
            String DColID = null;
            String schema = null;
            String language = null;
            String schemaURI = null;
            for (String ID : rpd.evaluate(XP_RELATEDCOLID)) {
                DColID = ID;
                if (DColID.equals(colId)) {
                    Iterator i$ = rpd.evaluate(XP_COLID).iterator();
                    while (i$.hasNext()) {
                        String MID;
                        MColID = MID = (String)i$.next();
                    }
                    i$ = rpd.evaluate(XP_COLNAME).iterator();
                    while (i$.hasNext()) {
                        String Name;
                        MColName = Name = (String)i$.next();
                        MColName = XMLTokenReplacer.XMLUnresolve(MColName);
                    }
                    i$ = rpd.evaluate(XP_SCHEMANAME).iterator();
                    while (i$.hasNext()) {
                        String sch;
                        schema = sch = (String)i$.next();
                    }
                    i$ = rpd.evaluate(XP_LANGUAGE).iterator();
                    while (i$.hasNext()) {
                        String l;
                        language = l = (String)i$.next();
                    }
                    i$ = rpd.evaluate(XP_SCHEMAURI).iterator();
                    while (i$.hasNext()) {
                        String uri;
                        schemaURI = uri = (String)i$.next();
                    }
                }
                logger.debug(DColID + " " + MColID + "(" + schema + ":" + language + ")");
                colInfo.setMetadataCollection(schemaURI, MColID, language);
            }
        }
        return colInfo;
    }
}

