/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.harvesting.common.db.tools;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.gcube.application.framework.harvesting.common.db.exceptions.SourceIDNotFoundException;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBProps;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Edge;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Table;

public class SourcePropsTools {
    public static String getSqlOfTable(DBProps dbProps, String tableName) {
        for (Table table : dbProps.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table.getSql();
        }
        return "";
    }

    public static String getPKeyOfTable(DBProps dbProps, String tableName) {
        for (Edge edge : dbProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(tableName)) continue;
            return edge.getPKeys();
        }
        return "";
    }

    public static ArrayList<String> getChildrenOfTable(DBProps dbProps, String tableName) {
        ArrayList<String> children = new ArrayList<String>();
        for (Edge edge : dbProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(tableName)) continue;
            children.add(edge.getChild());
        }
        return children;
    }

    public static ArrayList<Edge> getEdges(DBProps dbProps, String parentTableName) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : dbProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(parentTableName)) continue;
            edges.add(edge);
        }
        return edges;
    }

    public static DBProps parseSourceProps(String propsXML) throws SourceIDNotFoundException, Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBProps.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(propsXML);
            return (DBProps)jaxbUnmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new Exception(new Throwable("Error upon unmarshalling the properties XML", e));
        }
    }
}

