/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.harvesting.common.db.tools;

import java.io.File;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.gcube.application.framework.harvesting.common.db.exceptions.SourceIDNotFoundException;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSource;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSources;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Edge;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Table;

public class SourcePropsTools {
    public static String getSqlOfTable(DBSource dbUserProps, String tableName) {
        for (Table table : dbUserProps.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table.getSql();
        }
        return "";
    }

    public static String getPKeyOfTable(DBSource dbUserProps, String tableName) {
        for (Edge edge : dbUserProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(tableName)) continue;
            return edge.getPKeys();
        }
        return "";
    }

    public static ArrayList<String> getChildrenOfTable(DBSource dbUserProps, String tableName) {
        ArrayList<String> children = new ArrayList<String>();
        for (Edge edge : dbUserProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(tableName)) continue;
            children.add(edge.getChild());
        }
        return children;
    }

    public static ArrayList<Edge> getEdges(DBSource dbUserProps, String parentTableName) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : dbUserProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(parentTableName)) continue;
            edges.add(edge);
        }
        return edges;
    }

    public static DBSource parseSourceProps(String filePropsXMLPath, String sourceid) throws SourceIDNotFoundException {
        DBSources dbSources = new DBSources();
        try {
            File file = new File(filePropsXMLPath);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBSources.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            dbSources = (DBSources)jaxbUnmarshaller.unmarshal(file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        for (DBSource dbSource : dbSources.getDBSources()) {
            if (!dbSource.getSourceID().equalsIgnoreCase(sourceid)) continue;
            return dbSource;
        }
        throw new SourceIDNotFoundException(new Throwable("SourceID: " + sourceid));
    }
}

