package org.gcube.application.framework.search.library.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class CollectionsToStringHelper {
	
	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(CollectionsToStringHelper.class);

	public static void logHashMap (HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections){
		
		for(CollectionInfo colinfo : collections.keySet()){
			logger.info("Collection name: " + colinfo.getName());
			logger.info("Collection id: " + colinfo.getId());
			logger.info("Collection browsable fields:");
			for(Field browsableField : colinfo.getBrowsableFields())
				logger.info("Name: "+browsableField.getName()+" ID: "+browsableField.getId()+" toString(): "+browsableField.toString());
			logger.info("Collection presentable fields:");
			for(Field presentableField : colinfo.getPresentationFields())
				logger.info("Name: "+presentableField.getName()+" ID: "+presentableField.getId()+" toString(): "+presentableField.toString());
			
			ArrayList <CollectionInfo> subcollections = collections.get(colinfo);
			for(CollectionInfo subcolinfo : subcollections){
				logger.info("SubCollection name: " + subcolinfo.getName());
				logger.info("SubCollection id: " + subcolinfo.getId());
				logger.info("SubCollection browsable fields:");
				for(Field browsableField : subcolinfo.getBrowsableFields())
					logger.info("Name: "+browsableField.getName()+" ID: "+browsableField.getId()+" toString(): "+browsableField.toString());
				logger.info("Collection presentable fields:");
				for(Field presentableField : subcolinfo.getPresentationFields())
					logger.info("Name: "+presentableField.getName()+" ID: "+presentableField.getId()+" toString(): "+presentableField.toString());
			}
		}
		
	}
	
	/**
     * This method ensures that the output String has only
     * valid XML unicode characters as specified by the
     * XML 1.0 standard. For reference, please see
     * <a href="http://www.w3.org/TR/2000/REC-xml-20001006#NT-Char">the
     * standard</a>. This method will return an empty
     * String if the input is null or empty.
     *
     * @param in The String whose non-valid characters we want to remove.
     * @return The in String, stripped of non-valid characters.
     */
    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer(); // Used to hold the output.
        char current; // Used to reference the current character.

        if (in == null || ("".equals(in))) return ""; // vacancy test.
        for (int i = 0; i < in.length(); i++) {
            current = in.charAt(i); // NOTE: No IndexOutOfBoundsException caught here; it should not happen.
            if ((current == 0x9) ||
                (current == 0xA) ||
                (current == 0xD) ||
                ((current >= 0x20) && (current <= 0xD7FF)) ||
                ((current >= 0xE000) && (current <= 0xFFFD)) ||
                ((current >= 0x10000) && (current <= 0x10FFFF)))
                out.append(current);
        }
        return out.toString();
    }    
	

}

