/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.util;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.cache.factories.GenericResourceCacheEntryFactory;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.PresentableFieldInfo;
import org.gcube.application.framework.search.library.model.SearchableFieldInfo;
import org.gcube.application.framework.search.library.util.ArraysComparison;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FindFieldsInfo {
    public static final String ALL = "ALL";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String LOCAL_EXCLUDED_FIELDS_PROP_FILEPATH = "/excluded_fields.properties";
    public static final String CATALINA_EXCLUDED_FIELDS_PROP_FILEPATH = System.getProperty("catalina.base") + "/conf" + "/excluded_fields.properties";
    public static final String EXCLUDED_BROWSABLE_FIELD_NAMES_PROP = "excluded_browsable_field_names";
    private static final Logger logger = LoggerFactory.getLogger(FindFieldsInfo.class);
    public static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
    public static List<String> excludedBrowsableFieldNames = new ArrayList<String>();

    public static HashMap<CollectionInfo, ArrayList<CollectionInfo>> joinDynamicAndStaticConfiguration(String scope, boolean refresh) throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> collectionHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
        ArrayList<CollectionInfo> allCollections = FindFieldsInfo.retrieveCollectionsFieldsInfos(scope);
        if (allCollections == null || allCollections.size() == 0) {
            logger.debug("No available collections returned from Registry!");
            return collectionHierarchy;
        }
        try {
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = FindFieldsInfo.retrieveCollectionsInformation(scope, allCollections, refresh);
            colHierarchy = ArraysComparison.getSortedHashMap(colHierarchy);
            return colHierarchy;
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            return null;
        }
    }

    public static ArrayList<CollectionInfo> retrieveCollectionsFieldsInfos(String scope) throws InitialBridgingNotCompleteException, InternalErrorException {
        try {
            logger.debug("Bridging is about to start...");
            ResourceRegistry.startBridging();
        }
        catch (ResourceRegistryException e1) {
            logger.error("Exception:", (Throwable)e1);
            throw new InternalErrorException(e1.getCause());
        }
        List flds = null;
        try {
            flds = DataCollection.getCollectionsOfScope((boolean)true, (String)scope);
            logger.debug("Got " + flds.size() + " collections for scope " + scope + " from registy");
            String parentScope = new ScopeBean(scope).enclosingScope().toString();
            Map allSearchable = QueryHelper.getAllSearchableCollections((String)parentScope);
            Set allSearchableIDs = allSearchable.keySet();
            logger.debug("Got " + allSearchableIDs.size() + " surely searchable fields. Doing an intersection...");
            Iterator iter = flds.iterator();
            while (iter.hasNext()) {
                DataCollection dc = (DataCollection)iter.next();
                if (allSearchableIDs.contains(dc.getID())) continue;
                iter.remove();
            }
        }
        catch (ResourceRegistryException e1) {
            try {
                logger.error("Exception:", (Throwable)e1);
                if (!ResourceRegistry.isInitialBridgingComplete()) {
                    throw new InitialBridgingNotCompleteException(e1.getCause());
                }
                throw new InternalErrorException(e1.getCause());
            }
            catch (ResourceRegistryException rre) {
                logger.error("Exception:", (Throwable)rre);
                throw new InternalErrorException(rre.getCause());
            }
        }
        ArrayList<CollectionInfo> colInfos = new ArrayList<CollectionInfo>();
        logger.debug("Finding collection infos - number of collections: " + flds.size());
        for (int c = 0; c < flds.size(); ++c) {
            block30: {
                DataCollection myCollection = (DataCollection)flds.get(c);
                boolean fts = false;
                boolean geospatial = false;
                boolean searchable = true;
                boolean language = false;
                boolean sortable = false;
                String ftsId = "";
                Vector languages = new Vector();
                logger.debug("******************************************** START PROCEDURE *******************************" + c);
                logger.debug("Name of collection: " + myCollection.getName() + " id: " + myCollection.getID());
                try {
                    HashSet<String> capabilities = new HashSet<String>();
                    capabilities.add("=");
                    capabilities.add("=");
                    logger.debug("Trying to find searchable fields- id: " + myCollection.getID());
                    List fs = Field.getSearchableFieldsOfCollectionByCapabilities((boolean)true, (String)myCollection.getID(), capabilities);
                    logger.debug("Finding Field Infos - number of searchable fields: " + fs.size());
                    ArrayList<org.gcube.application.framework.search.library.model.Field> fields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                    for (int i = 0; i < fs.size(); ++i) {
                        sortable = false;
                        logger.debug("Name of Field: " + ((Field)fs.get(i)).getName());
                        org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                        inField.setDescription(((Field)fs.get(i)).getDescription());
                        inField.setId(((Field)fs.get(i)).getID());
                        inField.setLabel(((Field)fs.get(i)).getName());
                        inField.setName(((Field)fs.get(i)).getName());
                        if (((Field)fs.get(i)).getName().equals("allIndexes")) {
                            ftsId = ((Field)fs.get(i)).getID();
                            logger.debug(": " + ((Field)fs.get(i)).getID());
                            inField.setName("Any");
                            fts = true;
                        }
                        Set searchables = ((Field)fs.get(i)).getSearchables();
                        for (Searchable se : searchables) {
                            SearchableFieldInfo sfi = new SearchableFieldInfo();
                            sfi.setCollectionId(se.getCollection());
                            sfi.setFieldName(se.getField());
                            sfi.setId(se.getID());
                            sfi.setSortable(se.isOrder());
                            Set caps = se.getCapabilities();
                            sfi.setIndexCapabilities(caps);
                            inField.addSearchable(sfi);
                            if (!sfi.getCollectionId().equals(((Field)fs.get(i)).getID()) || !sfi.isSortable()) continue;
                            sortable = true;
                        }
                        Set presentables = ((Field)fs.get(i)).getPresentables();
                        for (Presentable pr : presentables) {
                            PresentableFieldInfo pfi = new PresentableFieldInfo();
                            pfi.setCollectionId(pr.getCollection());
                            pfi.setFieldName(pr.getField());
                            pfi.setId(pr.getID());
                            pfi.setSortable(pr.isOrder());
                            Set pres = pr.getPresentationInfo();
                            pfi.setPresentationInfo(pres);
                            inField.addPresentable(pfi);
                        }
                        inField.setSearchable(searchable);
                        inField.setSortable(sortable);
                        ArrayList<String> commonCaps = new ArrayList<String>();
                        if (inField.getSearchableFields() != null && inField.getSearchableFields().size() > 0) {
                            commonCaps.addAll(inField.getSearchableFields().get(0).getIndexCapabilities());
                        }
                        ArrayList<String> duplicated = commonCaps;
                        for (int s = 1; s < inField.getSearchableFields().size(); ++s) {
                            for (int cc = 0; cc < commonCaps.size(); ++cc) {
                                if (inField.getSearchableFields().get(s).getIndexCapabilities().contains(commonCaps.get(cc)) || !duplicated.contains(commonCaps.get(cc))) continue;
                                int ind = commonCaps.indexOf(commonCaps.get(cc));
                                duplicated.remove(ind);
                            }
                        }
                        commonCaps = duplicated;
                        inField.setIndexCapabilities(commonCaps);
                        fields.add(inField);
                    }
                    capabilities = new HashSet();
                    capabilities.add("geosearch");
                    logger.debug("Trying to find Geo relation- id: " + myCollection.getID());
                    List geoF = Field.getSearchableFieldsOfCollectionByCapabilities((boolean)true, (String)myCollection.getID(), capabilities);
                    org.gcube.application.framework.search.library.model.Field geoField = new org.gcube.application.framework.search.library.model.Field();
                    if (geoF != null && geoF.size() != 0) {
                        language = true;
                        geospatial = true;
                        geoField.setId(((Field)geoF.get(0)).getID());
                        geoField.setDescription(((Field)geoF.get(0)).getDescription());
                        geoField.setLabel(((Field)geoF.get(0)).getName());
                        geoField.setName(((Field)geoF.get(0)).getName());
                    } else {
                        logger.debug("No geo!- id: " + myCollection.getID());
                    }
                    ArrayList<String> allLanguages = new ArrayList<String>();
                    logger.debug("getting languages - id: " + myCollection.getID());
                    logger.debug(myCollection.getID());
                    DataLanguage dataLanguage = DataLanguage.getLanguages((String)myCollection.getID());
                    if (dataLanguage != null) {
                        logger.debug("dataLangs " + myCollection.getName());
                        HashMap fieldLanguages = dataLanguage.getFieldLanguages();
                        logger.debug("Number of languages: " + fieldLanguages.size() + " " + myCollection.getName() + " " + fields.size());
                        for (String fl : fieldLanguages.keySet()) {
                            logger.debug("KeyIs: " + fl + " " + myCollection.getName());
                        }
                        for (int i = 0; i < fields.size(); ++i) {
                            Set langs = (Set)fieldLanguages.get(((org.gcube.application.framework.search.library.model.Field)fields.get(i)).getId());
                            if (langs != null) {
                                logger.debug("field langs: " + langs.size() + " " + ((org.gcube.application.framework.search.library.model.Field)fields.get(i)).getId() + myCollection.getName());
                                for (String lang : langs) {
                                    ((org.gcube.application.framework.search.library.model.Field)fields.get(i)).addLanguage(lang);
                                    if (allLanguages.contains(lang)) continue;
                                    allLanguages.add(lang);
                                }
                                continue;
                            }
                            logger.debug("field langs NO " + ((org.gcube.application.framework.search.library.model.Field)fields.get(i)).getId() + myCollection.getName());
                        }
                        Set langs = (Set)fieldLanguages.get(geoField.getId());
                        if (langs != null) {
                            for (String lang : langs) {
                                geoField.addLanguage(lang);
                                if (allLanguages.contains(lang)) continue;
                                allLanguages.add(lang);
                            }
                        }
                        language = true;
                    } else {
                        logger.debug("DataLanguages map is null! " + myCollection.getID());
                    }
                    logger.debug("Trying to find Presentation Fields - id: " + myCollection.getID());
                    List prFs = Field.getPresentableFieldsOfCollection((boolean)true, (String)myCollection.getID());
                    logger.debug("Finding Presentation Field infor - number of presentation fields: " + prFs.size());
                    ArrayList<org.gcube.application.framework.search.library.model.Field> prFields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                    for (int i = 0; i < prFs.size(); ++i) {
                        logger.debug("Name of presentation field: " + ((Field)prFs.get(i)).getName());
                        org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                        inField.setDescription(((Field)prFs.get(i)).getDescription());
                        inField.setId(((Field)prFs.get(i)).getID());
                        inField.setLabel(((Field)prFs.get(i)).getName());
                        inField.setName(((Field)prFs.get(i)).getName());
                        prFields.add(inField);
                    }
                    logger.debug("Trying to find browsable fields - id: " + myCollection.getID());
                    List<Field> brFs = Field.getBrowsableFieldsOfCollection((boolean)true, (String)myCollection.getID());
                    logger.debug("Number of browsable fields found: " + brFs.size());
                    brFs = FindFieldsInfo.filterOutBrowsableFields(brFs, excludedBrowsableFieldNames);
                    logger.debug("Removed the not allowed browsable fields, new number of browsable fields: " + brFs.size());
                    ArrayList<org.gcube.application.framework.search.library.model.Field> brFields = new ArrayList<org.gcube.application.framework.search.library.model.Field>();
                    for (int i = 0; i < brFs.size(); ++i) {
                        logger.debug("Name of browsable field: " + brFs.get(i).getName());
                        org.gcube.application.framework.search.library.model.Field inField = new org.gcube.application.framework.search.library.model.Field();
                        inField.setDescription(brFs.get(i).getDescription());
                        inField.setId(brFs.get(i).getID());
                        inField.setLabel(brFs.get(i).getName());
                        inField.setName(brFs.get(i).getName());
                        language = true;
                        brFields.add(inField);
                    }
                    if (!language) break block30;
                    CollectionInfo colInfo = new CollectionInfo();
                    colInfo.setCollectionGroup(false);
                    colInfo.setDescription(myCollection.getDescription());
                    colInfo.setName(myCollection.getName());
                    logger.debug("Item name: " + myCollection.getName());
                    colInfo.setId(myCollection.getID());
                    logger.debug("Item id: " + myCollection.getID());
                    colInfo.setIndices(fields);
                    logger.debug("Supports fts: " + fts);
                    colInfo.setFts(fts);
                    colInfo.setCollectionType(myCollection.getCollectionType());
                    colInfo.setGeospatial(geospatial);
                    colInfo.setLanguages(allLanguages);
                    colInfo.setPresentationFields(prFields);
                    colInfo.setBrowsableFields(brFields);
                    colInfo.setFtsId(ftsId);
                    colInfo.setGeospatialField(geoField);
                    logger.debug("Set fts id: " + ftsId);
                    logger.debug("Adding COLLECTION: " + colInfo.getName());
                    colInfos.add(colInfo);
                }
                catch (ResourceRegistryException e) {
                    logger.error("Exception:", (Throwable)e);
                    continue;
                }
            }
            logger.debug("******************************************** END PROCEDURE *******************************");
        }
        logger.debug("Number of colINFOS: " + colInfos.size());
        return colInfos;
    }

    protected static List<Field> filterOutBrowsableFields(List<Field> initialList, List<String> notAllowedFieldNames) {
        ArrayList<Field> filteredList = new ArrayList<Field>();
        for (int i = 0; i < initialList.size(); ++i) {
            if (notAllowedFieldNames.contains(initialList.get(i).getName())) continue;
            filteredList.add(initialList.get(i));
        }
        return filteredList;
    }

    protected static HashMap<CollectionInfo, ArrayList<CollectionInfo>> retrieveCollectionsInformation(String vre, List<CollectionInfo> collections, boolean refresh) throws Exception {
        List scenarioSchemaInfo;
        logger.debug("About to retrieve the static configuration");
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)vre);
        query.put((Object)"name", (Object)"ScenarioCollectionInfo");
        if (refresh) {
            CachesManager.getInstance().getGenericResourceCache().remove((Serializable)query);
        }
        if ((scenarioSchemaInfo = (List)((Object)CachesManager.getInstance().getEhcache("genericResources", (CacheEntryFactory)new GenericResourceCacheEntryFactory()).get((Serializable)query).getValue())) == null || scenarioSchemaInfo.size() == 0) {
            logger.debug("The scenarioCollectionInfo is null");
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
            return colHierarchy;
        }
        logger.debug("Printing the static configuration");
        logger.debug("scenarioSchemaInfo.size()" + scenarioSchemaInfo.size());
        for (ISGenericResource gr : scenarioSchemaInfo) {
            logger.debug("gr.getBody():" + gr.getBody());
            logger.debug("gr.getDescription():" + gr.getDescription());
            logger.debug("gr.getId():" + gr.getId());
            logger.debug("gr.getName():" + gr.getName());
            logger.debug("gr.getSecondaryType():" + gr.getSecondaryType());
        }
        logger.debug(((ISGenericResource)scenarioSchemaInfo.get(0)).getBody());
        InputSource in = new InputSource(new StringReader(((ISGenericResource)scenarioSchemaInfo.get(0)).getBody()));
        Document doc = dfactory.newDocumentBuilder().parse(in);
        FindFieldsInfo.retrieveCollections(doc, collections);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = FindFieldsInfo.retrieveCollectionHierarchy(vre, doc, collections);
        return colHierarchy;
    }

    public static String findCollectionName(String id, String scope) {
        try {
            List collections = DataCollection.getCollectionsOfScope((boolean)true, (String)scope);
            for (int i = 0; i < collections.size(); ++i) {
                if (!((DataCollection)collections.get(i)).getID().equals(id)) continue;
                return ((DataCollection)collections.get(i)).getName();
            }
        }
        catch (ResourceRegistryException e) {
            logger.error("Exception:", (Throwable)e);
        }
        return null;
    }

    protected static void retrieveCollections(Document doc, List<CollectionInfo> collections) {
        CollectionInfo colInfo;
        String val;
        int i;
        ArrayList<CollectionInfo> availableCollections = new ArrayList<CollectionInfo>();
        NodeList res = doc.getElementsByTagName("collection");
        int n = res.getLength();
        logger.debug("Retrieving Static Configuration: The number of collections is: " + n);
        for (i = 0; i < n; ++i) {
            val = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
            logger.debug("The id of the collection read is: " + val);
            colInfo = null;
            colInfo = FindFieldsInfo.getCollectionInfoById(val, collections);
            if (colInfo == null) {
                logger.debug("Not available collection - omitting it");
                continue;
            }
            logger.debug("Printing collection Information gathered: ");
            logger.debug(colInfo.getName());
            logger.debug(colInfo.getId());
            logger.debug("end");
            val = res.item(i).getAttributes().getNamedItem("description").getNodeValue();
            colInfo.setDescription(val);
            val = res.item(i).getAttributes().getNamedItem("recno").getNodeValue();
            colInfo.setRecno(val);
            val = res.item(i).getAttributes().getNamedItem("creationDate").getNodeValue();
            colInfo.setCreationDate(val);
            availableCollections.add(colInfo);
        }
        collections.clear();
        for (CollectionInfo col : availableCollections) {
            collections.add(col);
        }
        res = doc.getElementsByTagName("collectionsGroup");
        logger.debug("CollectionsGroup size: " + n);
        n = res.getLength();
        for (i = 0; i < n; ++i) {
            colInfo = new CollectionInfo();
            try {
                val = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
                colInfo.setId(val);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
            try {
                val = res.item(i).getAttributes().getNamedItem("name").getNodeValue();
                colInfo.setName(val);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                val = res.item(i).getAttributes().getNamedItem("description").getNodeValue();
                colInfo.setDescription(val);
            }
            catch (Exception e) {
                // empty catch block
            }
            colInfo.setCollectionGroup(true);
            collections.add(colInfo);
        }
        logger.debug("***Number of collections:" + collections.size());
    }

    protected static HashMap<CollectionInfo, ArrayList<CollectionInfo>> retrieveCollectionHierarchy(String VREname, Document doc, List<CollectionInfo> collections) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("//collectionsGroup");
        NodeList res = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        int n = res.getLength();
        logger.debug("***** number of collection groups:" + n + "*******");
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> colHierarchy = new HashMap<CollectionInfo, ArrayList<CollectionInfo>>();
        HashMap<String, ArrayList<CollectionInfo>> groupIDsCollections = new HashMap<String, ArrayList<CollectionInfo>>();
        for (int i = 0; i < n; ++i) {
            String val = res.item(i).getAttributes().getNamedItem("id").getNodeValue();
            XPathExpression expr2 = xpath.compile("//collectionsGroup[@id=\"" + val + "\"]/collection");
            NodeList res2 = (NodeList)expr2.evaluate(doc, XPathConstants.NODESET);
            CollectionInfo colInfoGroup = FindFieldsInfo.getCollectionInfoById(val, collections);
            if (colInfoGroup != null) {
                for (int j = 0; j < res2.getLength(); ++j) {
                    CollectionInfo colInfo = FindFieldsInfo.getCollectionInfoById(res2.item(j).getAttributes().getNamedItem("id").getNodeValue(), collections);
                    if (colInfo == null) continue;
                    ArrayList<CollectionInfo> groupCollections = (ArrayList<CollectionInfo>)groupIDsCollections.get(colInfoGroup.getId());
                    if (groupCollections == null) {
                        groupCollections = new ArrayList<CollectionInfo>();
                    }
                    groupCollections.add(colInfo);
                    groupIDsCollections.put(colInfoGroup.getId(), groupCollections);
                }
                if (groupIDsCollections.get(colInfoGroup.getId()) != null) {
                    colHierarchy.put(colInfoGroup, (ArrayList<CollectionInfo>)groupIDsCollections.get(colInfoGroup.getId()));
                }
            }
            if (groupIDsCollections != null && colInfoGroup != null) {
                if (groupIDsCollections.get(colInfoGroup.getId()) == null) continue;
                logger.debug("***collection group " + i + " contains " + ((ArrayList)groupIDsCollections.get(colInfoGroup.getId())).size() + " collections***");
                continue;
            }
            logger.debug("No Available Collections Returned from Registry.");
        }
        return colHierarchy;
    }

    protected static CollectionInfo getCollectionInfoById(String colId, List<CollectionInfo> collections) {
        CollectionInfo colInfo = null;
        int n = collections.size();
        for (int i = 0; i < n; ++i) {
            logger.debug("*******" + collections.get(i).getId() + " vs. " + colId);
            if (!collections.get(i).getId().equals(colId)) continue;
            colInfo = collections.get(i);
            logger.debug("***collection found****");
            break;
        }
        return colInfo;
    }

    public static ArrayList<org.gcube.application.framework.search.library.model.Field> getCollectionPresentationFields(String colId, ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        SearchHelper sh = new SearchHelper(session);
        CollectionInfo colI = sh.findCollectionInfo(colId);
        ArrayList<org.gcube.application.framework.search.library.model.Field> fields = colI.getPresentationFields();
        return fields;
    }

    public static CollectionInfo findCollectionInfo(String colID, HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections) {
        if (collections != null) {
            for (CollectionInfo colInfo : collections.keySet()) {
                for (int c2 = 0; c2 < collections.get(colInfo).size(); ++c2) {
                    logger.info("compare: " + collections.get(colInfo).get(c2).getId() + " with: " + colID);
                    if (!collections.get(colInfo).get(c2).getId().equals(colID)) continue;
                    logger.info("equal!!");
                    return collections.get(colInfo).get(c2);
                }
            }
        } else {
            logger.info("No collections!!");
            return null;
        }
        logger.info("Null!!");
        return null;
    }

    public static List<CollectionInfo> searchCollectionInfo(String term, String whereToSearch, HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections) {
        term = (term = term.trim().toLowerCase()).startsWith("*") ? term.substring(1) : "(\\s|\\p{Punct})" + term;
        term = term.endsWith("*") ? term.substring(0, term.length() - 1) : term + "(\\s|\\p{Punct})";
        term = term.replaceAll("\\x2A", ".*");
        term = term.replaceAll("\\x3F", ".");
        Pattern pattern = Pattern.compile(term);
        boolean name = false;
        boolean descr = false;
        if (whereToSearch.equals(ALL)) {
            name = true;
            descr = true;
        } else if (whereToSearch.equals(NAME)) {
            name = true;
        } else if (whereToSearch.equals(DESCRIPTION)) {
            descr = true;
        }
        ArrayList<CollectionInfo> res = new ArrayList<CollectionInfo>();
        for (CollectionInfo colInfo : collections.keySet()) {
            for (int c2 = 0; c2 < collections.get(colInfo).size(); ++c2) {
                if (name && pattern.matcher(" " + collections.get(colInfo).get(c2).getName().toLowerCase() + " ").find()) {
                    res.add(collections.get(colInfo).get(c2));
                    continue;
                }
                if (!descr || !pattern.matcher(" " + collections.get(colInfo).get(c2).getDescription().toLowerCase() + " ").find()) continue;
                res.add(collections.get(colInfo).get(c2));
            }
        }
        return res;
    }

    static {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = new FileInputStream(CATALINA_EXCLUDED_FIELDS_PROP_FILEPATH);
            props.load(in);
        }
        catch (Exception e) {
            logger.debug("Couldn't access property file " + CATALINA_EXCLUDED_FIELDS_PROP_FILEPATH + ", parsing local file " + LOCAL_EXCLUDED_FIELDS_PROP_FILEPATH);
            in = FindFieldsInfo.class.getResourceAsStream(LOCAL_EXCLUDED_FIELDS_PROP_FILEPATH);
            try {
                props.load(in);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (props.getProperty(EXCLUDED_BROWSABLE_FIELD_NAMES_PROP) != null) {
            excludedBrowsableFieldNames = Arrays.asList(props.getProperty(EXCLUDED_BROWSABLE_FIELD_NAMES_PROP).split(","));
        }
        for (int i = 0; i < excludedBrowsableFieldNames.size(); ++i) {
            excludedBrowsableFieldNames.set(i, excludedBrowsableFieldNames.get(i).trim());
        }
        logger.debug("Excluding " + excludedBrowsableFieldNames.size() + " browsable fields");
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

