/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.userprofiles.library.impl;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.apache.xpath.XPathAPI;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.userprofiles.cache.factories.ProfileCacheEntryFactory;
import org.gcube.application.framework.userprofiles.commons.ProfileService;
import org.gcube.application.framework.userprofiles.library.UserProfileInfoI;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.personalization.profileadministration.stubs.ProfileAdministrationPortType;
import org.gcube.personalization.userprofileaccess.stubs.SetElement;
import org.gcube.personalization.userprofileaccess.stubs.SetElementValue;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessPortType;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserProfile
implements UserProfileInfoI {
    protected ASLSession session;
    protected final GCUBELog logger = new GCUBELog((Object)this);
    protected static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();

    public UserProfile(String extrenalSessionID, String username) {
        this.session = SessionManager.getInstance().getASLSession(extrenalSessionID, username);
    }

    public UserProfile(ASLSession session) {
        this.session = session;
    }

    @Override
    public HashMap<String, String> getMetadataXSLTs(String username) {
        HashMap<String, String> metaXSLTs = new HashMap<String, String>();
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        try {
            NodeList nodes = XPathAPI.selectNodeList((Node)profile, (String)"//xslts/metadataxslt/xslt");
            for (int i = 0; i < nodes.getLength(); ++i) {
                String name = "";
                String id = "";
                NodeList children = nodes.item(i).getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    if (children.item(j).getNodeType() != 1) continue;
                    if (children.item(j).getNodeName().equals("name")) {
                        name = children.item(j).getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!children.item(j).getNodeName().equals("id")) continue;
                    id = children.item(j).getFirstChild().getNodeValue();
                }
                System.out.println("Inside GetMetadataXslts - initial name is: " + name);
                int a = name.lastIndexOf("-|-");
                name = name.substring(0, a);
                System.out.println("After: " + name + " " + id);
                metaXSLTs.put(name, id);
            }
        }
        catch (TransformerException e) {
            this.logger.error((Object)"Failed to create a transformer", (Throwable)e);
        }
        return metaXSLTs;
    }

    @Override
    public HashMap<String, ArrayList<String>> getPresentationFields(String username) {
        HashMap<String, ArrayList<String>> collectionsFields = new HashMap<String, ArrayList<String>>();
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        this.logger.debug((Object)"The user profile is: ");
        try {
            DOMSource domSource = new DOMSource(profile);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            this.logger.debug((Object)sw.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NodeList nodes = XPathAPI.selectNodeList((Node)profile, (String)"//collections/collection");
            this.logger.debug((Object)("Number of collection nodes is: " + nodes.getLength()));
            for (int i = 0; i < nodes.getLength(); ++i) {
                String id = "";
                String colId = "";
                NamedNodeMap attrs = nodes.item(i).getAttributes();
                Node colIdNode = attrs.getNamedItem("id");
                colId = colIdNode.getNodeValue();
                this.logger.debug((Object)("IDS: " + colId + " " + colIdNode.getTextContent()));
                NodeList children = nodes.item(i).getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    id = children.item(j).getTextContent();
                    this.logger.debug((Object)("Field id: " + id));
                    ArrayList<String> fieldIds = collectionsFields.get(colId);
                    if (fieldIds == null) {
                        fieldIds = new ArrayList();
                    }
                    fieldIds.add(id);
                    this.logger.debug((Object)("Putting field: " + id));
                    this.logger.debug((Object)("For Collection Putting: " + colId));
                    collectionsFields.put(colId, fieldIds);
                }
            }
        }
        catch (TransformerException e) {
            this.logger.error((Object)"Failed to create a transformer", (Throwable)e);
        }
        return collectionsFields;
    }

    @Override
    public String getUserProfile(String username) {
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        CharArrayWriter fos = new CharArrayWriter();
        Document profile = (Document)CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        try {
            return this.createStringFromDomTree(profile);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to serialize the profile", (Throwable)e);
            return null;
        }
    }

    private String createStringFromDomTree(Node tree) throws Exception {
        String nodeString = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(tree);
        transformer.transform(source, result);
        nodeString = sw.getBuffer().toString();
        return nodeString;
    }

    @Override
    public void setUserProfile(String username, String profile) {
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        InputSource profileIn = new InputSource(new ByteArrayInputStream(profile.getBytes()));
        try {
            Document profileDoc = dfactory.newDocumentBuilder().parse(profileIn);
            CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).put(new Element((Object)query, (Object)profileDoc));
        }
        catch (SAXException e) {
            this.logger.error((Object)"Failed to update profile cache", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Failed to update profile cache", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)"Failed to update profile cache", (Throwable)e);
        }
        ProfileService profileService = new ProfileService(username, this.session.getScope());
        UserProfileAccessPortType port = profileService.getUserProfileAccess(this.session.getCredential());
        try {
            port.updateUserProfile(profile);
        }
        catch (GCUBEFault e) {
            this.logger.error((Object)"Failed to update profile at the service", (Throwable)e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)"Failed to update profile at the service", (Throwable)e);
        }
    }

    @Override
    public void createUserProfile(String username) {
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
    }

    @Override
    public void dropUserProfile(String username) {
        ProfileService profileService = new ProfileService(username, this.session.getScope());
        ProfileAdministrationPortType pa = profileService.getProfileAdministration((GSSCredential)this.session.getCredential());
        try {
            pa.dropUserProfile(username);
        }
        catch (GCUBEFault e) {
            this.logger.error((Object)"Failed to drop profile at the service", (Throwable)e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)"Failed to drop profile at the service", (Throwable)e);
        }
    }

    @Override
    public String[] getElement(String username, String element) {
        ArrayList<String> results = new ArrayList<String>();
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        System.out.println("Retrieved the profile from cache: " + profile);
        try {
            int i;
            NodeList nodes = XPathAPI.selectNodeList((Node)profile, (String)element);
            this.logger.debug((Object)("elements found: " + nodes.getLength()));
            for (i = 0; i < nodes.getLength(); ++i) {
                try {
                    this.logger.debug((Object)this.createStringFromDomTree(nodes.item(i)));
                    results.add(this.createStringFromDomTree(nodes.item(i)));
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to serialize the profile", (Throwable)e);
                }
            }
            String[] res = new String[results.size()];
            for (i = 0; i < res.length; ++i) {
                res[i] = (String)results.get(i);
                System.out.println("Printing nodes from profile");
                System.out.println(res[i]);
            }
            return res;
        }
        catch (TransformerException e) {
            this.logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getElementValue(String username, String element) {
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            return (String)xpath.evaluate(element + "/text()", profile, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            this.logger.error((Object)"An error occured while exeuting XPath", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setDefaultProfile(String defaultProfile) {
        ProfileService profileService = new ProfileService(this.session.getUsername(), this.session.getScope());
        ProfileAdministrationPortType pa = profileService.getProfileAdministration((GSSCredential)this.session.getCredential());
        try {
            pa.setDefaultProfile(defaultProfile);
        }
        catch (GCUBEFault e) {
            this.logger.error((Object)"An error occured while setting the default profile", (Throwable)e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)"An error occured while setting the default profile", (Throwable)e);
        }
    }

    @Override
    public void setElementValue(String username, String element, String value) {
        System.out.println("Inside setElementValue");
        this.logger.debug((Object)("Element:" + element + " Value" + value));
        String replacement = element.lastIndexOf(47) > -1 ? element.substring(element.lastIndexOf(47)) : element;
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node node = (Node)xpath.evaluate(element, profile, XPathConstants.NODE);
            if (profile == null) {
                System.out.println("The profile is null");
                return;
            }
            System.out.println("The profile is: ");
            DOMSource domSource = new DOMSource(profile);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            System.out.println(sw.toString());
            if (node == null) {
                System.out.println("The node evalutated is null");
                return;
            }
            System.out.println("The value is: " + value);
            Node textOfNode = node.getFirstChild();
            node.removeChild(textOfNode);
            node.appendChild(profile.createTextNode(value));
            System.out.println("The profile after the change is: ");
            domSource = new DOMSource(profile);
            sw = new StringWriter();
            result = new StreamResult(sw);
            tf = TransformerFactory.newInstance();
            transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            System.out.println(sw.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"Element not found. Failed to set the value at the profile.", (Throwable)e);
        }
        CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).put(new Element((Object)query, (Object)profile));
        this.setElementToService(username, element, value);
        CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).setTimeToLive(-1);
        this.session.removeAttribute("transformers");
        this.session.removeAttribute("schemaTrans");
        this.session.removeAttribute("XSLT_ids");
    }

    public boolean deleteElement(String username, String elementName) {
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        try {
            NodeList nodes;
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                nodes = (NodeList)xpath.evaluate(elementName, profile, XPathConstants.NODESET);
            }
            catch (Exception e) {
                this.logger.error((Object)"Element not found", (Throwable)e);
                return false;
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Node parentNode = node.getParentNode();
                if (parentNode == null) continue;
                parentNode.removeChild(node);
            }
            this.deleteElementToService(username, elementName);
            CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).put(new Element((Object)query, (Object)profile));
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to delete the elements from the profile.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void setElement(String username, String path, String elementName, String elementValue) throws Exception {
        System.out.println("Inside setElement");
        String replacement = elementName.lastIndexOf(47) > -1 ? elementName.substring(elementName.lastIndexOf(47)) : elementName;
        QueryString query = new QueryString();
        query.put((Object)"vre", (Object)this.session.getOriginalScopeName());
        query.put((Object)"username", (Object)username);
        Document profile = (Document)CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).getObjectValue();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = null;
        try {
            node = (Node)xpath.evaluate(path, profile, XPathConstants.NODE);
        }
        catch (Throwable all) {
            this.logger.error((Object)"Element not found. Failed to evaluate the XPATH.", all);
        }
        org.w3c.dom.Element el = profile.createElement(elementName);
        if (el == null) {
            System.out.println("The xpath hasn't been evaluated");
            return;
        }
        el.appendChild(profile.createTextNode(elementValue));
        node.appendChild(el);
        System.out.println("putting element in profile cache");
        System.out.println("username: " + username);
        System.out.println("vre: " + this.session.getOriginalScopeName());
        CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).put(new Element((Object)query, (Object)profile));
        System.out.println("creating element to service");
        System.out.println("username: " + username);
        System.out.println("elementName: " + elementName);
        System.out.println("elementValue: " + elementValue);
        System.out.println("After setting the element in profile!!: " + this.createStringFromDomTree(profile));
        this.createElementToService(path, username, elementName, elementValue);
        CachesManager.getInstance().getEhcache("profiles", (CacheEntryFactory)new ProfileCacheEntryFactory()).get((Serializable)query).setTimeToLive(-1);
        this.session.removeAttribute("transformers");
        this.session.removeAttribute("schemaTrans");
        this.session.removeAttribute("XSLT_ids");
    }

    protected void createElementToService(String path, String username, String name, String value) {
        ProfileService profileService = new ProfileService(username, this.session.getScope());
        UserProfileAccessPortType port = profileService.getUserProfileAccess(this.session.getCredential());
        SetElement setElement = new SetElement();
        setElement.setElementName(name);
        setElement.setValue(value);
        setElement.setPath(path);
        try {
            port.setElement(setElement);
        }
        catch (GCUBEFault e) {
            this.logger.error((Object)"An error occured while adding element to service", (Throwable)e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)"An error occured while adding element to service", (Throwable)e);
        }
    }

    protected void setElementToService(String username, String element, String value) {
        ProfileService profileService = new ProfileService(username, this.session.getScope());
        UserProfileAccessPortType port = profileService.getUserProfileAccess(this.session.getCredential());
        SetElementValue setElement = new SetElementValue();
        setElement.setElementName(element);
        setElement.setValue(value);
        try {
            port.setElementValue(setElement);
        }
        catch (GCUBEFault e) {
            this.logger.error((Object)"An error occured while setting the element to service", (Throwable)e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)"An error occured while setting the element to service", (Throwable)e);
        }
    }

    protected void deleteElementToService(String username, String elementName) {
        ProfileService profileService = new ProfileService(username, this.session.getScope());
        UserProfileAccessPortType port = profileService.getUserProfileAccess(this.session.getCredential());
        try {
            port.deleteElement(elementName);
        }
        catch (GCUBEFault e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

