package org.gcube.application.framework.userprofiles.library.impl;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import net.sf.ehcache.Element;

import org.apache.xpath.XPathAPI;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.CacheEntryConstants;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.userprofiles.cache.factories.ProfileCacheEntryFactory;
import org.gcube.application.framework.userprofiles.commons.ProfileService;
import org.gcube.application.framework.userprofiles.library.UserProfileInfoI;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.personalization.profileadministration.stubs.ProfileAdministrationPortType;
import org.gcube.personalization.userprofileaccess.stubs.SetElement;
import org.gcube.personalization.userprofileaccess.stubs.SetElementValue;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessPortType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfile implements UserProfileInfoI {
	
	protected ASLSession session;

	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(UserProfile.class);

	protected static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();

	/**
	 * @param extrenalSessionID the external session ID. In case of a web application using ASL, this is the http session ID
	 * @param username the username of the user that makes the request
	 */
	public UserProfile(String extrenalSessionID, String username)
	{
		session = SessionManager.getInstance().getASLSession(extrenalSessionID, username);
	}


	/**
	 * @param session the D4SSession 
	 */
	public UserProfile(ASLSession session) {
		super();
		this.session = session;
	}

	/** {@inheritDoc}*/
	public HashMap<String, String> getMetadataXSLTs(String username) {
		HashMap<String, String> metaXSLTs = new HashMap<String, String>();
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		try {
			NodeList nodes = XPathAPI.selectNodeList(profile, "//xslts/metadataxslt/xslt");
			for(int i=0; i < nodes.getLength(); i++)
			{
				String name = "";
				String id = "";
				NodeList children = nodes.item(i).getChildNodes();
				for(int j =0; j < children.getLength(); j ++)
				{
					if(children.item(j).getNodeType() == Node.ELEMENT_NODE)
					{
						if(children.item(j).getNodeName().equals("name"))
							name = children.item(j).getFirstChild().getNodeValue();
						else if(children.item(j).getNodeName().equals("id"))
							id = children.item(j).getFirstChild().getNodeValue();
					}
				}
				logger.info("Inside GetMetadataXslts - initial name is: " + name);
				
				int a = name.lastIndexOf("-|-");
				name = name.substring(0, a);
				logger.info("After: " + name + " " + id);
				metaXSLTs.put(name, id);
			}
		} catch (TransformerException e) {
			logger.error("Failed to create a transformer",e);
		}
		return metaXSLTs;
	}


	/** {@inheritDoc}*/
	public HashMap<String, ArrayList<String>> getPresentationFields(String username) {
		HashMap<String, ArrayList<String>> collectionsFields = new HashMap<String, ArrayList<String>>();
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		logger.debug("The user profile is: ");
		try {
			DOMSource domSource = new DOMSource(profile);
			StringWriter sw = new StringWriter();
			StreamResult result = new StreamResult(sw);
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			transformer.transform(domSource, result);
			logger.debug(sw.toString());
		} catch (Exception e) {
			logger.error("Exception:", e);
		}
		try {
			NodeList nodes = XPathAPI.selectNodeList(profile, "//collections/collection");
			logger.debug("Number of collection nodes is: " + nodes.getLength());
			for(int i=0; i < nodes.getLength(); i++)
			{
				String id = "";
				String colId = "";
				//colId = nodes.item(i).getTextContent();
				NamedNodeMap attrs = nodes.item(i).getAttributes();
				Node colIdNode = attrs.getNamedItem("id");
				colId = colIdNode.getNodeValue();
				logger.debug("IDS: " + colId + " " + colIdNode.getTextContent());
				NodeList children = nodes.item(i).getChildNodes();
				for(int j =0; j < children.getLength(); j ++)
				{
					//id = children.item(j).getNodeValue();
					id = children.item(j).getTextContent();
					logger.debug("Field id: " + id);
					ArrayList<String> fieldIds = collectionsFields.get(colId);
					if (fieldIds == null)
						fieldIds = new ArrayList<String>();
					fieldIds.add(id);
					logger.debug("Putting field: " + id);
					logger.debug("For Collection Putting: " + colId);
					collectionsFields.put(colId, fieldIds);
				}
			}
		} catch (TransformerException e) {
			logger.error("Failed to create a transformer",e);
		}
		return collectionsFields;
	}

	/** {@inheritDoc}*/
	public String getUserProfile(String username) {
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		CharArrayWriter fos = new CharArrayWriter();
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		try {
			return createStringFromDomTree(profile);
		} catch (Exception e) {
			logger.error("Failed to serialize the profile",e);
			return null;
		}
	}

	private String createStringFromDomTree(Node tree) throws Exception {
		String nodeString = null;
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();
		transformer.setOutputProperty("omit-xml-declaration", "yes");
		StringWriter sw = new StringWriter();
		StreamResult result = new StreamResult(sw);
		DOMSource source = new DOMSource(tree);
		transformer.transform( source, result );
		nodeString = sw.getBuffer().toString();
		return nodeString;
	}

	/** {@inheritDoc}*/
	public void setUserProfile(String username, String profile) {
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		InputSource profileIn = new InputSource(new ByteArrayInputStream(profile.getBytes()));
		try {
			Document profileDoc = dfactory.newDocumentBuilder().parse(profileIn);
			CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).put(new Element(query, profileDoc));
		} catch (SAXException e) {
			logger.error("Failed to update profile cache",e);
		} catch (IOException e) {
			logger.error("Failed to update profile cache",e);
		} catch (ParserConfigurationException e) {
			logger.error("Failed to update profile cache",e);
		}

		ProfileService profileService = new ProfileService(username,  session.getScope());
		UserProfileAccessPortType port = profileService.getUserProfileAccess(session.getCredential());
//		SetElementValue setElement = new SetElementValue();
//		setElement.setElementName("/userprofile");
		
//		String toCut = "<userprofile>";
//		String profil = profile.substring(toCut.length(), profile.length() - (toCut.length() + 1));
//		setElement.setValue(profil);
		try {
			port.updateUserProfile(profile);
			//port.setElementValue(setElement);
			session.removeAttribute("presentationFields");
		} catch (GCUBEFault e) {
			logger.error("Failed to update profile at the service",e);
		} catch (RemoteException e) {
			logger.error("Failed to update profile at the service",e);
		}
	}

	/** {@inheritDoc}*/
	public void createUserProfile(String username) {
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue();
	}

	/** {@inheritDoc}*/
	public void dropUserProfile(String username) {
		ProfileService profileService = new ProfileService(username,  session.getScope());
		ProfileAdministrationPortType pa = profileService.getProfileAdministration(session.getCredential());
		try {
			pa.dropUserProfile(username);
			session.removeAttribute("presentationFields");
		} catch (GCUBEFault e) {
			logger.error("Failed to drop profile at the service",e);
		} catch (RemoteException e) {
			logger.error("Failed to drop profile at the service",e);
		}
	}

	/** {@inheritDoc}*/
	public String[] getElement(String username, String element) {
		List<String> results = new ArrayList<String>();
		String[] res;
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		logger.info("Retrieved the profile from cache: " + profile);
		try {
			NodeList nodes = XPathAPI.selectNodeList(profile, element);
			logger.debug("elements found: " + nodes.getLength());
			for(int i=0; i < nodes.getLength(); i++)
			{
				try {
					logger.debug(createStringFromDomTree(nodes.item(i)));
					results.add(createStringFromDomTree(nodes.item(i)));
				} catch (Exception e) {
					logger.error("Failed to serialize the profile",e);
				}
			}
			res = new String[results.size()];
			for(int i=0; i<res.length; i++) {
				res[i] = results.get(i);
				logger.info("Printing nodes from profile");
				logger.info(res[i]);
			}
			
			return res;
		} catch (TransformerException e) {
			logger.error("",e);
		}
		return null;
	}
	
	


	/** {@inheritDoc}*/
	public String getElementValue(String username, String element) {
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		XPath xpath = XPathFactory.newInstance().newXPath();	 
        try {
			return (String) xpath.evaluate(element+"/text()", profile, XPathConstants.STRING);
		} catch (XPathExpressionException e) {
			logger.error("An error occured while exeuting XPath",e);
			return null;
		}
	}

	/** {@inheritDoc}*/
	public void setDefaultProfile(String defaultProfile) {
		ProfileService profileService = new ProfileService(session.getUsername(),  session.getScope());
		ProfileAdministrationPortType pa = profileService.getProfileAdministration(session.getCredential());
		try {
			pa.setDefaultProfile(defaultProfile);
		} catch (GCUBEFault e) {
			logger.error("An error occured while setting the default profile",e);
		} catch (RemoteException e) {
			logger.error("An error occured while setting the default profile",e);
		}
	}

	/** {@inheritDoc}*/
	public void setElementValue(String username, String element, String value) {
		logger.info("Inside setElementValue");
		logger.debug("Element:" + element + " Value" + value);
		//TODO: na afairethoun me to pou allaxei to service!
		String replacement = (element.lastIndexOf('/') > -1)? element.substring(element.lastIndexOf('/')): element;
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		XPath xpath = XPathFactory.newInstance().newXPath();
        try {
        	// Retrieve the element
        	Node node = (Node)xpath.evaluate(element, profile, XPathConstants.NODE);
        	// set the new value

     //   	node.setTextContent(value);
        	if (profile == null) {
        		logger.info("The profile is null");
        		return;
        	}
        	logger.info("The profile is: " );
        	DOMSource domSource = new DOMSource(profile);
			StringWriter sw = new StringWriter();
			StreamResult result = new StreamResult(sw);
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			transformer.transform(domSource, result);
			logger.info(sw.toString());
			
        	if (node == null) {
        		logger.info("The node evalutated is null");
        		return;
        	}
        	logger.info("The value is: " + value);
        	Node textOfNode = node.getFirstChild();
        	node.removeChild(textOfNode); 
        	node.appendChild(profile.createTextNode(value)); 
        	logger.info("The profile after the change is: ");
        	domSource = new DOMSource(profile);
        	sw = new StringWriter();
        	result = new StreamResult(sw);
        	tf = TransformerFactory.newInstance();
        	transformer = tf.newTransformer();
        	transformer.transform(domSource, result);
        	logger.info(sw.toString());
        }
        catch (Exception e) {
        	logger.error("Element not found. Failed to set the value at the profile.",e);
        }
        CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).put(new Element(query, profile));
        // Transform profile to a Stirng from a  DOM tree
		setElementToService(username, element, value);
		
		// Refresh the cache?
	//	CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).setTimeToLive(-1);
		CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).remove(query);
		
		session.removeAttribute("transformers");
		session.removeAttribute("schemaTrans");
		session.removeAttribute("XSLT_ids");
		session.removeAttribute("presentationFields");
	}
	
	public boolean deleteElement(String username, String elementName) {

		

		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue());
	  
	  try {
	         
	         NodeList nodes;
	         XPath xpath = XPathFactory.newInstance().newXPath();
	         try {
	          nodes = (NodeList) xpath.evaluate(elementName, profile, XPathConstants.NODESET);
	         }
	         catch (Exception e) {
	          logger.error("Element not found", e);
	          return false;
	         }
	   
	         for (int i=0; i<nodes.getLength(); i++) {
	          Node node = nodes.item(i);
	          Node parentNode = node.getParentNode();
	          if (parentNode != null) {
	           parentNode.removeChild(node);
	          }
	         }
	         
	         /* updates the content of the user profile */
	        deleteElementToService(username, elementName);
			CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).put(new Element(query, profile));
	        session.removeAttribute("presentationFields");
	      }
	      catch(Exception e) {
	       logger.error("Failed to delete the elements from the profile.", e);
			return false;
	      } 
	      return true;
	 }
	
	
	public void setElement (String username, String path, String elementName, String elementValue) throws Exception {
		logger.info("Inside setElement");
		String replacement = (elementName.lastIndexOf('/') > -1)? elementName.substring(elementName.lastIndexOf('/')):elementName;
		
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		XPath xpath = XPathFactory.newInstance().newXPath();
	
		/* TODO error check for the parameters. if the path is a node etc */
        Node node = null;
        try {
        	node = (Node)xpath.evaluate(path, profile, XPathConstants.NODE);	
//	        CachesManager.getInstance().getProfileCache().put(new Element(query, profile));
	        // Transform profile to a Stirng from a  DOM tree
//			setElementToService(username, elementName, elementValue);
        }
        catch(Throwable all) {
        	logger.error("Element not found. Failed to evaluate the XPATH.", all);
        }

        
        /* creates a new element with the specified name and value
         * and appends it with the specified node.
         */
        /* creates a new element with the specified name and value
         * and appends it with the specified node.
         */
        //	Node rootEl = profile.getDocumentElement();
	        Node el = profile.createElement(elementName);
	        	//el.setTextContent(elementValue);
	        if  (el == null) {
	        	logger.info("The xpath hasn't been evaluated");
	        	return;
	        }

	        el.appendChild(profile.createTextNode(elementValue)); 
	        
	        node.appendChild(el);
	        //node.appendChild(el);
	        
	        /* Creates a string from the DOM tree */
	        logger.info("putting element in profile cache");
	        logger.info("username: " + username);
	        logger.info("vre: " + session.getOriginalScopeName());
	        CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).put(new Element(query, profile));
	        
	        logger.info("creating element to service");
	        logger.info("username: " + username);
	        logger.info("elementName: " + elementName);
	        logger.info("elementValue: " + elementValue);
	        
	        logger.info("After setting the element in profile!!: " + createStringFromDomTree(profile));	
	        createElementToService(path, username, elementName, elementValue);
	        
	     // Refresh the cache?
			//CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).get(query).setTimeToLive(-1);
	        CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheEntryConstants.profileCache, new ProfileCacheEntryFactory()).remove(query);
	        
	        session.removeAttribute("transformers");
	        session.removeAttribute("schemaTrans");
	        session.removeAttribute("XSLT_ids");
	        session.removeAttribute("presentationFields");
        
     }	
	
	protected void createElementToService(String path, String username, String name, String value) {
		ProfileService profileService = new ProfileService(username, session.getScope());
		UserProfileAccessPortType port = profileService.getUserProfileAccess(session.getCredential());
		SetElement setElement = new SetElement();
		setElement.setElementName(name);
		setElement.setValue(value);
		setElement.setPath(path);
		try {
			port.setElement(setElement);
		} catch (GCUBEFault e) {
			logger.error("An error occured while adding element to service", e);
		} catch (RemoteException e) {
			logger.error("An error occured while adding element to service", e);
		}
	}
	
	protected void setElementToService(String username, String element, String value)
	{

		ProfileService profileService = new ProfileService(username,  session.getScope());
		UserProfileAccessPortType port = profileService.getUserProfileAccess(session.getCredential());
		SetElementValue setElement = new SetElementValue();
		setElement.setElementName(element);
		setElement.setValue(value);
		try {
			port.setElementValue(setElement);
		} catch (GCUBEFault e) {
			logger.error("An error occured while setting the element to service",e);
		} catch (RemoteException e) {
			logger.error("An error occured while setting the element to service",e);
		}
	}
	
	protected void deleteElementToService (String username, String elementName) {
		ProfileService profileService = new ProfileService(username, session.getScope());
		UserProfileAccessPortType port = profileService.getUserProfileAccess(session.getCredential());
		
		try {
			port.deleteElement(elementName);
		} catch (GCUBEFault e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		} catch (RemoteException e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		}
	}

}
