/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.vremanagement.vremanagement.impl;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.core.security.PortalSecurityManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.vremanagement.vremanagement.ISInfoI;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBECollectionQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEMCollectionQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.resources.GCUBECollection;
import org.gcube.common.core.resources.GCUBEExternalRunningInstance;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.vremanagement.ghnmanager.stubs.AddScopeInputParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.GHNManagerPortType;
import org.gcube.common.vremanagement.ghnmanager.stubs.ScopeRIParams;
import org.gcube.common.vremanagement.ghnmanager.stubs.service.GHNManagerServiceAddressingLocator;
import org.ietf.jgss.GSSCredential;

public class ISInfo
implements ISInfoI {
    protected ASLSession session;
    protected static ISClient client = null;
    protected static ISPublisher publisher = null;

    public ISInfo(ASLSession session) {
        this.session = session;
        try {
            publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (client == null) {
            try {
                client = (ISClient)GHNContext.getImplementation(ISClient.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                client = null;
            }
        }
    }

    @Override
    public List<XMLResult> queryIS(String query) {
        try {
            GCUBEGenericQuery queryMan = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
            queryMan.setExpression(query);
            System.out.println(this.session.getOriginalScopeName());
            return client.execute((ISQuery)queryMan, this.session.getScope());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<XMLResult>();
        }
    }

    @Override
    public List<RPDocument> getWS(String type) {
        WSResourceQuery query = null;
        try {
            query = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/gc:ServiceClass", type)});
            return client.execute((ISQuery)query, this.session.getScope());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<RPDocument>();
        }
    }

    @Override
    public void addGHNToScope(String url) {
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            url = "http://" + url + "/wsrf/services/gcube/common/vremanagement/GHNManager";
            String[] vos = this.session.getOriginalScopeName().split("/");
            System.out.println("querying for vo: /" + vos[1]);
            endpoint.setAddress((AttributedURI)new Address(url));
            GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
            GHNManagerPortType pt = locator.getGHNManagerPortTypePort(endpoint);
            pt = (GHNManagerPortType)ServiceContextManager.applySecurity((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)("/" + vos[1])), (GSSCredential)this.session.getCredential());
            AddScopeInputParams params = new AddScopeInputParams();
            params.setScope(this.session.getOriginalScopeName());
            params.setMap("");
            pt.addScope(params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeGHNToScope(String url) {
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            url = "http://" + url + "/wsrf/services/gcube/common/vremanagement/GHNManager";
            String[] vos = this.session.getOriginalScopeName().split("/");
            System.out.println("querying for vo: /" + vos[1]);
            endpoint.setAddress((AttributedURI)new Address(url));
            GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
            GHNManagerPortType pt = locator.getGHNManagerPortTypePort(endpoint);
            pt = (GHNManagerPortType)ServiceContextManager.applySecurity((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)("/" + vos[1])), (GSSCredential)this.session.getCredential());
            pt.removeScope(this.session.getOriginalScopeName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addRIToScope(String url, String className, String name) {
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress((AttributedURI)new Address(url));
            GHNManagerServiceAddressingLocator locator = new GHNManagerServiceAddressingLocator();
            GHNManagerPortType pt = locator.getGHNManagerPortTypePort(endpoint);
            pt = (GHNManagerPortType)ServiceContextManager.applySecurity((Remote)pt, (ASLSession)this.session);
            ScopeRIParams params = new ScopeRIParams();
            params.setClazz(className);
            params.setName(name);
            params.setScope(this.session.getOriginalScopeName());
            pt.addRIToScope(params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addExternalRIToVRE(File file) {
        String message;
        GCUBEExternalRunningInstance ri = null;
        try {
            ri = (GCUBEExternalRunningInstance)GHNContext.getImplementation(GCUBEExternalRunningInstance.class);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String ret = "";
        if (file.exists()) {
            try {
                ri.load((Reader)new FileReader(file));
            }
            catch (Exception e) {
                message = "Error while loading profile for the External Running Instance with id=" + ri.getID() + "\n";
                System.out.println(message);
                e.printStackTrace();
                ret = ret + message;
            }
        } else {
            String message2 = "An error occur during the approval of the External Running Instance with id=" + ri.getID() + "\n";
            System.out.println(message2);
            ret = ret + message2;
        }
        try {
            publisher.registerGCUBEResource((GCUBEResource)ri, this.session.getScope(), (GCUBESecurityManager)new PortalSecurityManager(this.session));
        }
        catch (ISPublisherException e) {
            message = "Registration error for the External Running Instance with id=" + ri.getID() + "\n";
            System.out.println(message);
            e.printStackTrace();
            ret = ret + message;
        }
    }

    @Override
    public void removeExternalRIToVRE(String id) {
        try {
            publisher.removeGCUBEResource(id, "ExternalRunningInstance", this.session.getScope(), (GCUBESecurityManager)new PortalSecurityManager(this.session));
        }
        catch (ISPublisherException e) {
            String message = "Registration error for the External Running Instance with id=" + id + "\n";
            System.out.println(message);
            e.printStackTrace();
        }
    }

    @Override
    public boolean existsGHN(String namePort) {
        try {
            System.out.println("GHN: " + namePort);
            GCUBEGenericQuery query = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
            query.setExpression("for $ghn in collection(\"/db/Profiles/GHN\")//Document/Data/child::*[local-name()='Profile']/Resource where $ghn/Profile/GHNDescription/Name/string() eq '" + namePort + "' return $ghn");
            String[] vos = this.session.getOriginalScopeName().split("/");
            System.out.println("querying for vo: /" + vos[1]);
            List resources = client.execute((ISQuery)query, GCUBEScope.getScope((String)("/" + vos[1])));
            if (resources == null || resources.size() == 0) {
                System.out.println("Resources are null or empty");
                return false;
            }
            System.out.println("Found resources!!!!");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<GCUBECollection> getCollections(GCUBEScope scope) throws Exception {
        try {
            GCUBECollectionQuery collectionquery = (GCUBECollectionQuery)client.getQuery(GCUBECollectionQuery.class);
            return client.execute((ISQuery)collectionquery, scope);
        }
        catch (Exception e) {
            System.out.println("Error during Collections retrieving in scope " + scope.getName());
            e.printStackTrace();
            throw new Exception("Error during Collections retrieving in scope " + scope.getName(), e);
        }
    }

    @Override
    public List<GCUBEMCollection> getMCollections(GCUBEScope scope, String collectionID) throws Exception {
        try {
            GCUBEMCollectionQuery mcolQuery = (GCUBEMCollectionQuery)client.getQuery(GCUBEMCollectionQuery.class);
            mcolQuery.addGenericCondition("$result/child::*[local-name()='Profile']/RelatedCollection/CollectionID/string() eq '" + collectionID + "'");
            return client.execute((ISQuery)mcolQuery, scope);
        }
        catch (Exception e) {
            System.out.println("Error during MCollections retrieving in scope " + scope.getName());
            e.printStackTrace();
            throw new Exception("Error during MCollections retrieving in scope " + scope.getName(), e);
        }
    }

    @Override
    public List<RPDocument> getXMLIndices(GCUBEScope scope, String mcollectionID) throws Exception {
        try {
            WSResourceQuery queryXMLIndices = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            queryXMLIndices.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceClass", "MetadataManagement"), new AtomicCondition("//gc:ServiceName", "XMLIndexer"), new AtomicCondition("/child::*[local-name()='Id']", mcollectionID), new AtomicCondition("/child::*[local-name()='AccessType']", "GCUBEDaix")});
            return client.execute((ISQuery)queryXMLIndices, scope);
        }
        catch (Exception e) {
            System.out.println("Error during Indices retrieving in scope " + scope.getName());
            e.printStackTrace();
            throw new Exception("Error during Indices retrieving in scope " + scope.getName(), e);
        }
    }

    @Override
    public List<RPDocument> getIndices(GCUBEScope scope, String mcollectionID) throws Exception {
        try {
            WSResourceQuery queryXMLIndices = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            queryXMLIndices.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceClass", "Index"), new AtomicCondition("/child::*[local-name()='CollectionID']", mcollectionID)});
            return client.execute((ISQuery)queryXMLIndices, scope);
        }
        catch (Exception e) {
            System.out.println("Error during Indices retrieving in scope " + scope.getName());
            e.printStackTrace();
            throw new Exception("Error during Indices retrieving in scope " + scope.getName(), e);
        }
    }

    @Override
    public List<RPDocument> getCollectionIndices(GCUBEScope scope, String collectionID) throws Exception {
        try {
            WSResourceQuery queryXMLIndices = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            queryXMLIndices.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceClass", "Index"), new AtomicCondition("/child::*[local-name()='CollectionID']", collectionID)});
            return client.execute((ISQuery)queryXMLIndices, scope);
        }
        catch (Exception e) {
            System.out.println("Error during collection Indices retrieving in scope " + scope.getName());
            e.printStackTrace();
            throw new Exception("Error during collection Indices retrieving  in scope " + scope.getName(), e);
        }
    }

    @Override
    public GCUBECollection getCollection(GCUBEScope scope, String collectionID) throws Exception {
        try {
            GCUBECollectionQuery Collectionquery = (GCUBECollectionQuery)client.getQuery(GCUBECollectionQuery.class);
            Collectionquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ID", collectionID)});
            return (GCUBECollection)client.execute((ISQuery)Collectionquery, scope).get(0);
        }
        catch (Exception e) {
            System.out.println("Error during Collection (by ID " + collectionID + ") retrieving in scope " + scope.getName());
            e.printStackTrace();
            throw new Exception("Error during Collection (by ID " + collectionID + ") retrieving in scope " + scope.getName(), e);
        }
    }
}

