/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.vremanagement.vremanagement.impl;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.vremanagement.vremanagement.VREGeneratorI;
import org.gcube.common.core.types.VOID;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.vremanagement.vremodeler.stubs.CheckedRows;
import org.gcube.vremanagement.vremodeler.stubs.CollectionArray;
import org.gcube.vremanagement.vremodeler.stubs.CollectionList;
import org.gcube.vremanagement.vremodeler.stubs.CollectionType;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityIDArray;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityItem;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityList;
import org.gcube.vremanagement.vremodeler.stubs.GHNArray;
import org.gcube.vremanagement.vremodeler.stubs.GHNList;
import org.gcube.vremanagement.vremodeler.stubs.GHNType;
import org.gcube.vremanagement.vremodeler.stubs.MetadataFormatCollectionRelation;
import org.gcube.vremanagement.vremodeler.stubs.MetadataFormatItem;
import org.gcube.vremanagement.vremodeler.stubs.MetadataFormatRelation;
import org.gcube.vremanagement.vremodeler.stubs.ModelerFactoryPortType;
import org.gcube.vremanagement.vremodeler.stubs.ModelerServicePortType;
import org.gcube.vremanagement.vremodeler.stubs.ReportList;
import org.gcube.vremanagement.vremodeler.stubs.RunningInstance;
import org.gcube.vremanagement.vremodeler.stubs.SetMDFormatArgs;
import org.gcube.vremanagement.vremodeler.stubs.VREDescription;
import org.gcube.vremanagement.vremodeler.stubs.service.ModelerFactoryServiceAddressingLocator;
import org.gcube.vremanagement.vremodeler.stubs.service.ModelerServiceAddressingLocator;

public class VREGenerator
implements VREGeneratorI {
    ASLSession session;
    ModelerServicePortType modelPortType;
    protected static AtomicInteger vreId = new AtomicInteger(0);

    public VREGenerator(ASLSession session, String id) {
        this(session);
        EndpointReferenceType epr = this.getEprGivenID(id);
        System.out.println("****\n\nCalled  VREGenerator(ASLSession session, String epr): epr: \n" + epr);
        this.session = session;
        this.modelPortType = this.applySecurityEPR(epr);
    }

    public VREGenerator(ASLSession session) {
        this.session = session;
        this.modelPortType = null;
        this.getModelPortType();
    }

    protected ModelerServicePortType applySecurityEPR(EndpointReferenceType epr) {
        try {
            ModelerServiceAddressingLocator mSALocator = new ModelerServiceAddressingLocator();
            this.modelPortType = (ModelerServicePortType)ServiceContextManager.applySecurity((Remote)mSALocator.getModelerServicePortTypePort(epr), (ASLSession)this.session);
            return this.modelPortType;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ReportList getAllVREs(ASLSession session) {
        EndpointReference[] modelerURIs;
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        ModelerFactoryPortType mFPType = null;
        ModelerFactoryServiceAddressingLocator mFSLocator = new ModelerFactoryServiceAddressingLocator();
        try {
            modelerURIs = RIsManager.getInstance().getISCache(session.getScope()).getEPRsFor("VREManagement", "VREModeler", SrvType.FACTORY.name());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        for (int i = 0; i < modelerURIs.length; ++i) {
            try {
                System.out.println("getModelFactoryPortTypePort(epr)");
                serviceEPR.setAddress((AttributedURI)new Address(modelerURIs[vreId.getAndIncrement() % modelerURIs.length].getAddress().toString()));
                mFPType = (ModelerFactoryPortType)ServiceContextManager.applySecurity((Remote)mFSLocator.getModelerFactoryPortTypePort(serviceEPR), (ASLSession)session);
                return mFPType.getAllVREs(new VOID());
            }
            catch (ServiceException e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private EndpointReferenceType getEprGivenID(String id) {
        EndpointReference[] modelerURIs;
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        ModelerFactoryPortType mFPType = null;
        ModelerFactoryServiceAddressingLocator mFSLocator = new ModelerFactoryServiceAddressingLocator();
        try {
            modelerURIs = RIsManager.getInstance().getISCache(this.session.getScope()).getEPRsFor("VREManagement", "VREModeler", SrvType.FACTORY.name());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        for (int i = 0; i < modelerURIs.length; ++i) {
            try {
                System.out.println("getModelFactoryPortTypePort(epr)");
                serviceEPR.setAddress((AttributedURI)new Address(modelerURIs[vreId.getAndIncrement() % modelerURIs.length].getAddress().toString()));
                mFPType = (ModelerFactoryPortType)ServiceContextManager.applySecurity((Remote)mFSLocator.getModelerFactoryPortTypePort(serviceEPR), (ASLSession)this.session);
                return mFPType.getEPRbyId(id);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void removeVRE(ASLSession session, String id) {
        EndpointReference[] modelerURIs;
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        ModelerFactoryPortType mFPType = null;
        ModelerFactoryServiceAddressingLocator mFSLocator = new ModelerFactoryServiceAddressingLocator();
        try {
            modelerURIs = RIsManager.getInstance().getISCache(session.getScope()).getEPRsFor("VREManagement", "VREModeler", SrvType.FACTORY.name());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
        for (int i = 0; i < modelerURIs.length; ++i) {
            try {
                System.out.println("getModelFactoryPortTypePort(epr)");
                serviceEPR.setAddress((AttributedURI)new Address(modelerURIs[vreId.getAndIncrement() % modelerURIs.length].getAddress().toString()));
                mFPType = (ModelerFactoryPortType)ServiceContextManager.applySecurity((Remote)mFSLocator.getModelerFactoryPortTypePort(serviceEPR), (ASLSession)session);
                System.out.println("ID RECEIVED TO REMOVE:" + id);
                mFPType.removeVRE(id);
                break;
            }
            catch (ServiceException e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String[] checkVREStatus() throws RemoteException {
        return null;
    }

    @Override
    public void deployVRE() throws RemoteException {
        this.modelPortType.deployVRE(new VOID());
    }

    @Override
    public String getCollection() throws RemoteException {
        String toReturn = "";
        CollectionList cList = this.modelPortType.getCollection(new VOID());
        if (cList.getList() == null) {
            toReturn = "<ResultSet></ResultSet>";
        } else {
            toReturn = "<ResultSet>";
            CollectionType[] cTypes = cList.getList();
            for (int i = 0; i < cTypes.length; ++i) {
                toReturn = toReturn + "\n<Collection>\n";
                toReturn = toReturn + "<ID>" + cTypes[i].getId() + "</ID>\n";
                toReturn = toReturn + "<Name>" + cTypes[i].getName() + "</Name>\n";
                toReturn = toReturn + "<Info>\n";
                toReturn = toReturn + "<Description>" + cTypes[i].getInfo().getDescription() + "</Description>\n";
                toReturn = toReturn + "<NumberOfMembers>" + cTypes[i].getInfo().getNumberOfMembers() + "</NumberOfMembers>\n";
                toReturn = toReturn + "<CreationTime>" + cTypes[i].getInfo().getCreationTime().getTimeInMillis() + "</CreationTime>\n";
                toReturn = toReturn + "<LastUpdateTime>" + cTypes[i].getInfo().getLastUpdateTime().getTimeInMillis() + "</LastUpdateTime>\n";
                toReturn = toReturn + "</Info>\n";
                toReturn = toReturn + "<Selected>" + cTypes[i].isSelected() + "</Selected>\n";
                toReturn = toReturn + "\n</Collection>";
            }
            toReturn = toReturn + "\n</ResultSet>";
        }
        return toReturn;
    }

    @Override
    public String getGHNs() throws RemoteException {
        String toReturn = "";
        GHNList list = this.modelPortType.getGHNs(new VOID());
        if (list.getList() == null) {
            toReturn = "<ResultSet></ResultSet>";
        } else {
            toReturn = "<ResultSet>";
            GHNType[] types = list.getList();
            for (int i = 0; i < types.length; ++i) {
                toReturn = toReturn + "<GHN>";
                toReturn = toReturn + "<ID>" + types[i].getId() + "</ID>";
                toReturn = toReturn + "<Host>" + types[i].getHost() + "</Host>";
                toReturn = toReturn + "<Info>";
                RunningInstance[] ris = types[i].getRelatedRIs();
                if (ris != null) {
                    toReturn = toReturn + "<RunningInstances>";
                    for (int j = 0; j < ris.length; ++j) {
                        toReturn = toReturn + "<RunningInstance>";
                        toReturn = toReturn + "<Name>" + ris[j].getServiceName() + "</Name>";
                        toReturn = toReturn + "<Class>" + ris[j].getServiceClass() + "</Class>";
                        toReturn = toReturn + "</RunningInstance>";
                    }
                    toReturn = toReturn + "</RunningInstances>";
                }
                toReturn = toReturn + "<Security>" + types[i].getSecurity() + "</Security>";
                toReturn = toReturn + "<UpTime>" + types[i].getUpTime() + "</UpTime>";
                toReturn = toReturn + "<Memory>";
                toReturn = toReturn + "<VirtualAvailable>" + types[i].getMemory().getVirtulaAvailable() + "</VirtualAvailable>";
                toReturn = toReturn + "<LocalAvailableSpace>" + types[i].getMemory().getLocalAvailableSpace() + "</LocalAvailableSpace>";
                toReturn = toReturn + "</Memory>";
                toReturn = toReturn + "<Site>";
                toReturn = toReturn + "<Location>" + types[i].getSite().getLocation() + "</Location>";
                toReturn = toReturn + "<Country>" + types[i].getSite().getCountry() + "</Country>";
                toReturn = toReturn + "<Domain>" + types[i].getSite().getDomain() + "</Domain>";
                toReturn = toReturn + "</Site>";
                toReturn = toReturn + "<Libraries />";
                toReturn = toReturn + "</Info>";
                toReturn = toReturn + "<Selected>" + types[i].isSelected() + "</Selected>";
                toReturn = toReturn + "</GHN>";
            }
            toReturn = toReturn + "</ResultSet>";
        }
        return toReturn;
    }

    @Override
    public String getVREModel() throws RemoteException {
        String toReturn = "";
        VREDescription desc = this.modelPortType.getDescription(new VOID());
        if (desc == null) {
            toReturn = "<Resultset></Resultset>";
        } else {
            toReturn = "<Resultset>";
            toReturn = toReturn + "<Name>" + (desc.getName() == null ? "" : desc.getName()) + "</Name>";
            toReturn = toReturn + "<Description>" + (desc.getDescription() == null ? "" : desc.getDescription()) + "</Description>";
            toReturn = toReturn + "<VREDesigner>" + (desc.getDesigner() == null ? "" : desc.getDesigner()) + "</VREDesigner>";
            toReturn = toReturn + "<VREManager>" + (desc.getManager() == null ? "" : desc.getManager()) + "</VREManager>";
            toReturn = toReturn + "<StartTime>" + desc.getStartTime().getTimeInMillis() + "</StartTime>";
            toReturn = toReturn + "<EndTime>" + desc.getEndTime().getTimeInMillis() + "</EndTime>";
            toReturn = toReturn + "</Resultset>";
        }
        return toReturn;
    }

    @Override
    public String[] getExistingNamesVREs() {
        return new String[0];
    }

    @Override
    public String getFunctionality() throws RemoteException {
        String toReturn = "";
        FunctionalityList list = this.modelPortType.getFunctionality(new VOID());
        if (list.getList() == null) {
            toReturn = "<Resultset></Resultset>";
        } else {
            toReturn = "<Resultset>";
            FunctionalityItem[] item = list.getList();
            for (int i = 0; i < item.length; ++i) {
                toReturn = toReturn + "<Functionality enableCS=\"false\" id=\"" + item[i].getId() + "\"" + " name=\"" + item[i].getName() + "\" selected=\"" + item[i].isSelected() + "\" >";
                toReturn = toReturn + "<FunctionalityDescription>" + item[i].getDescription() + "</FunctionalityDescription>";
                if (item[i].getChilds() != null) {
                    FunctionalityItem[] childrenItem = item[i].getChilds();
                    for (int j = 0; j < childrenItem.length; ++j) {
                        toReturn = toReturn + "<child>";
                        toReturn = toReturn + "<Functionality enableCS=\"false\" id=\"" + childrenItem[j].getId() + "\"" + " name=\"" + childrenItem[j].getName() + "\" selected=\"" + childrenItem[j].isSelected() + "\" >";
                        toReturn = toReturn + "<FunctionalityDescription>" + childrenItem[j].getDescription() + "</FunctionalityDescription>";
                        toReturn = toReturn + "</Functionality>";
                        toReturn = toReturn + "</child>";
                    }
                }
                toReturn = toReturn + "</Functionality>";
            }
            toReturn = toReturn + "</Resultset>";
        }
        return toReturn;
    }

    @Override
    public String getMetadataRelatedToCollection() throws RemoteException {
        String toReturn = "";
        Object mdFResponse = null;
        MetadataFormatItem[] mList = mdFResponse.getMetadataFromats();
        MetadataFormatCollectionRelation[] cList = mdFResponse.getCollections();
        if (mList == null && cList == null) {
            toReturn = "<Resultset></Resultset>";
        } else {
            int i;
            toReturn = "<Resultset>";
            toReturn = toReturn + "<MFL>";
            for (i = 0; i < mList.length; ++i) {
                toReturn = toReturn + "<Element>";
                toReturn = toReturn + "<MFID>" + mList[i].getId() + "</MFID>";
                toReturn = toReturn + "<MFName>" + mList[i].getName() + "</MFName>";
                toReturn = toReturn + "<URI>" + mList[i].getUri() + "</URI>";
                toReturn = toReturn + "<Language>" + mList[i].getLanguage() + "</Language>";
                toReturn = toReturn + "</Element>";
            }
            toReturn = toReturn + "</MFL>";
            toReturn = toReturn + "<CollectionList>";
            for (i = 0; i < cList.length; ++i) {
                toReturn = toReturn + "<Collection>";
                toReturn = toReturn + "<CollectionID>" + cList[i].getCollId() + "</CollectionID>";
                toReturn = toReturn + "<Name>" + cList[i].getName() + "</Name>";
                toReturn = toReturn + "<Description>" + cList[i].getDescription() + "</Description>";
                if (cList[i].getMfList() != null) {
                    toReturn = toReturn + "<MetadataFormatList>";
                    MetadataFormatRelation[] mdItems = cList[i].getMfList();
                    for (int j = 0; j < mdItems.length; ++j) {
                        toReturn = toReturn + "<MetadataFormat>";
                        toReturn = toReturn + "<Id>" + mdItems[j].getId() + "</Id>";
                        toReturn = toReturn + "<Selectable>" + mdItems[j].isSelectable() + "</Selectable>";
                        toReturn = toReturn + "<Selected>" + mdItems[j].isSelected() + "</Selected>";
                        toReturn = toReturn + "</MetadataFormat>";
                    }
                    toReturn = toReturn + "</MetadataFormatList>";
                }
                toReturn = toReturn + "<CollectionID>" + cList[i].getCollId() + "</CollectionID>";
                toReturn = toReturn + "<CollectionID>" + cList[i].getCollId() + "</CollectionID>";
                toReturn = toReturn + "</Collection>";
            }
            toReturn = toReturn + "</CollectionList>";
            toReturn = toReturn + "</Resultset>";
        }
        return toReturn;
    }

    @Override
    public String getQuality() throws RemoteException {
        return this.modelPortType.getQuality(new VOID());
    }

    @Override
    public void setCollection(String[] collections) throws RemoteException {
        this.modelPortType.setCollection(new CollectionArray(collections));
    }

    @Override
    public void setGHNs(String[] GHNElements, String candidateGHN) throws RemoteException {
        GHNArray ghnArray = new GHNArray(GHNElements, candidateGHN);
        this.modelPortType.setGHNs(ghnArray);
    }

    @Override
    public void setVREModel(String VREName, String VREDescription2, String VREDesigner, String VREManager, long startTime, long endTime) throws RemoteException {
        VREDescription vreDesc = new VREDescription();
        vreDesc.setDescription(VREDescription2);
        vreDesc.setDesigner(VREDesigner);
        vreDesc.setManager(VREManager);
        vreDesc.setName(VREName);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(startTime);
        vreDesc.setStartTime(cal);
        cal.setTimeInMillis(endTime);
        vreDesc.setEndTime(cal);
        this.modelPortType.setDescription(vreDesc);
    }

    @Override
    public void setVREtoPendingState() throws RemoteException {
        this.modelPortType.setVREtoPendingState(new VOID());
    }

    @Override
    public void setFunctionality(String[] csIDElement, String[] functionalityIDElement) throws RemoteException {
        FunctionalityIDArray functArray = new FunctionalityIDArray();
        functArray.setCsIDElement(csIDElement);
        functArray.setFunctionalityIDElement(functionalityIDElement);
        this.modelPortType.setFunctionality(functArray);
    }

    @Override
    public void setMetadataRelatedToCollection(String[] collectionIDArray, boolean[][] checkedArray, String[] mdFormatIDArray) throws RemoteException {
        SetMDFormatArgs mdFormat = new SetMDFormatArgs();
        int numRows = checkedArray.length;
        CheckedRows[] checkedRows = new CheckedRows[numRows];
        for (int i = 0; i < numRows; ++i) {
            CheckedRows row;
            checkedRows[i] = row = new CheckedRows(checkedArray[i]);
        }
        mdFormat.setCheckedArray(checkedRows);
        mdFormat.setCollectionIDArray(collectionIDArray);
        mdFormat.setMdFormatIDArray(mdFormatIDArray);
    }

    @Override
    public void setQuality(String quality) throws RemoteException {
        this.modelPortType.setQuality(quality);
    }

    private synchronized void getModelPortType() {
        System.out.println("---    Get ModelPortType   ---");
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        ModelerFactoryPortType mFPType = null;
        if (this.modelPortType == null) {
            EndpointReference[] modelerURIs;
            System.out.println("VREEndpointReferenceType==null");
            ModelerFactoryServiceAddressingLocator mFSLocator = new ModelerFactoryServiceAddressingLocator();
            try {
                modelerURIs = RIsManager.getInstance().getISCache(this.session.getScope()).getEPRsFor("VREManagement", "VREModeler", SrvType.FACTORY.name());
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return;
            }
            System.out.println("vre modelers: " + modelerURIs.length);
            for (int i = 0; i < modelerURIs.length; ++i) {
                try {
                    System.out.println("getModelFactoryPortTypePort(epr)");
                    serviceEPR.setAddress((AttributedURI)new Address(modelerURIs[vreId.getAndIncrement() % modelerURIs.length].getAddress().toString()));
                    mFPType = (ModelerFactoryPortType)ServiceContextManager.applySecurity((Remote)mFSLocator.getModelerFactoryPortTypePort(serviceEPR), (ASLSession)this.session);
                    EndpointReferenceType VREEndpointReferenceType = mFPType.createResource(new VOID());
                    mFPType.getAllVREs(new VOID());
                    ModelerServiceAddressingLocator mSALocator = new ModelerServiceAddressingLocator();
                    this.modelPortType = (ModelerServicePortType)ServiceContextManager.applySecurity((Remote)mSALocator.getModelerServicePortTypePort(VREEndpointReferenceType), (ASLSession)this.session);
                    System.out.println("Attaching Credential to port type");
                    break;
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new Random(System.currentTimeMillis()).nextInt(modelerURIs.length);
                }
            }
        } else {
            System.out.println("modelPortType!=null");
        }
        System.out.println(this.modelPortType);
        System.out.println("--- Get ModelPortType done ---");
    }

    @Override
    public String getVREepr() {
        return this.modelPortType.toString();
    }
}

