/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.oaipmh;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.http.oaipmh.Data.Pair;
import org.gcube.application.framework.http.oaipmh.GCubeRepository;
import org.gcube.application.framework.http.oaipmh.GCubeTools;
import org.gcube.application.framework.http.oaipmh.Tools;
import org.gcube.application.framework.http.oaipmh.impl.SearchClientImpl;
import org.gcube.application.framework.oaipmh.Response;
import org.gcube.application.framework.oaipmh.constants.MetadataConstants;
import org.gcube.application.framework.oaipmh.objectmappers.Identifier;
import org.gcube.application.framework.oaipmh.objectmappers.Record;
import org.gcube.application.framework.oaipmh.objectmappers.Repository;
import org.gcube.application.framework.oaipmh.tools.Toolbox;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.NoSearchMasterEPRFoundException;
import org.gcube.application.framework.search.library.exception.QuerySyntaxException;
import org.gcube.application.framework.search.library.exception.gRS2AvailableRecordsRetrievalException;
import org.gcube.application.framework.search.library.exception.gRS2NoRecordReadWithinTimeIntervalException;
import org.gcube.application.framework.search.library.exception.gRS2ReaderException;
import org.gcube.application.framework.search.library.exception.gRS2RecordDefinitionException;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Criterion;
import org.gcube.application.framework.search.library.model.Field;
import org.gcube.application.framework.search.library.model.ISearchClient;
import org.gcube.application.framework.search.library.model.Query;
import org.gcube.application.framework.search.library.model.SearchASLException;
import org.gcube.application.framework.search.library.util.DisableButtons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAI2
extends HttpServlet {
    private static final String HOST_PROPS_FILENAME = "hosting.properties";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(OAI2.class);
    private Repository repository;
    private HashMap<CollectionInfo, ArrayList<CollectionInfo>> gCubeCollections;
    private static boolean refreshSet;
    private boolean usernameSet = false;
    private String url;
    private String email;
    private HashMap<String, String> collections;
    private HashMap<String, ArrayList<Pair>> browsableFields;
    private HashMap<String, ArrayList<Pair>> presentableFields;

    public OAI2() {
        refreshSet = false;
        this.gCubeCollections = new HashMap();
        this.collections = new HashMap();
        this.browsableFields = new HashMap();
        this.presentableFields = new HashMap();
        Thread.currentThread().getContextClassLoader().getResource(HOST_PROPS_FILENAME).getPath();
        Properties props = new Properties();
        try {
            FileInputStream fip = new FileInputStream(Thread.currentThread().getContextClassLoader().getResource(HOST_PROPS_FILENAME).getPath());
            props.load(fip);
            this.url = new URL((String)props.get("protocol"), (String)props.get("host"), Integer.parseInt((String)props.get("port")), "").toString();
            this.email = (String)props.get("adminEmail");
        }
        catch (IOException e2) {
            logger.debug("Could not parse properties file hosting.properties Using empty hostname for repoository replies and empty email fields");
            this.url = "";
            this.email = "";
        }
    }

    public void setRefreshCollections(int interval, String username, String sessionID) {
        new Timer().schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, interval);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("doGet()");
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)"ShowCollectionInfos");
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        logger.debug("username of authentication: " + username);
        HttpSession session = request.getSession();
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), username);
        logger.debug("Username: " + username + " sessionID: " + session.getId() + " mysession.getScope(): " + mysession.getScope());
        logger.debug("Getting collections");
        this.gCubeCollections = GCubeTools.getGCubeCollections((ASLSession)mysession);
        if (this.gCubeCollections == null) {
            response.setContentType("text/html");
            try {
                response.sendError(404, "Server is not ready to serve any OAI-PMH requests. Wait for him to synchronize with the available collections.");
            }
            catch (IOException e) {
                // empty catch block
            }
            logger.debug("gCubeCollections is null");
            return;
        }
        if (this.gCubeCollections.isEmpty()) {
            response.setContentType("text/html");
            try {
                response.sendError(404, "Server is not able to serve any OAI-PMH requests. Server has no available collections.");
            }
            catch (IOException e) {
                // empty catch block
            }
            logger.debug("No collections available");
            return;
        }
        if (this.collections != null) {
            this.collections.clear();
        }
        if (this.browsableFields != null) {
            this.browsableFields.clear();
        }
        if (this.presentableFields != null) {
            this.presentableFields.clear();
        }
        for (CollectionInfo group : this.gCubeCollections.keySet()) {
            for (CollectionInfo collectionInfo : (ArrayList)this.gCubeCollections.get(group)) {
                ArrayList colBrowsableFields = collectionInfo.getBrowsableFields();
                ArrayList colPresentableFields = collectionInfo.getPresentationFields();
                if (colBrowsableFields == null || colBrowsableFields.isEmpty()) continue;
                this.collections.put(collectionInfo.getId(), collectionInfo.getName());
                ArrayList<Pair> browsable = new ArrayList<Pair>();
                for (Field field : colBrowsableFields) {
                    browsable.add(new Pair(field.getId(), field.getName()));
                }
                this.browsableFields.put(collectionInfo.getId(), browsable);
                ArrayList<Pair> presentable = new ArrayList<Pair>();
                for (Field field : colPresentableFields) {
                    presentable.add(new Pair(field.getId(), field.getName()));
                }
                this.presentableFields.put(collectionInfo.getId(), presentable);
            }
        }
        try {
            this.repository = GCubeRepository.createRepository((String)this.url, (String)this.email, (HashMap)this.collections, (HashMap)this.browsableFields, (HashMap)this.presentableFields);
        }
        catch (IOException ex) {
            logger.debug("could not create the gCube repository, details: " + ex);
        }
        Properties properties = new Properties();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            properties.put(paramName, request.getParameterValues(paramName)[0]);
        }
        logger.debug("Serving http get request");
        int cursor = properties.get("resumptionToken") == null ? 0 : Integer.parseInt((String)properties.get("resumptionToken"));
        if ("Identify".equalsIgnoreCase((String)properties.get("verb"))) {
            this.serveIdentify(properties, response);
        } else if ("ListMetadataFormats".equalsIgnoreCase((String)properties.get("verb"))) {
            this.serveListMetadataFormats(properties, response);
        } else if ("ListSets".equalsIgnoreCase((String)properties.get("verb"))) {
            this.serveListSets(properties, response);
        } else if ("ListIdentifiers".equalsIgnoreCase((String)properties.get("verb"))) {
            logger.debug("Serving Identifiers...");
            try {
                this.serveListIdentifiers(properties, response, mysession, cursor, 1000);
            }
            catch (Exception e) {
                logger.debug("Failed to parse identifiers" + e);
            }
        } else if ("ListRecords".equalsIgnoreCase((String)properties.get("verb"))) {
            try {
                this.serveListRecords(properties, response, mysession, cursor, 1000);
            }
            catch (Exception e) {
                logger.debug("Exception occurred while serving the records... Details: " + e);
            }
        } else if ("GetRecord".equalsIgnoreCase((String)properties.get("verb"))) {
            response.setContentType("text/html");
            try {
                this.serveGetRecord(properties, response, mysession);
            }
            catch (Exception e) {
                logger.debug("Failed to parse identifiers" + e);
            }
        }
    }

    private void serveIdentify(Properties requestParams, HttpServletResponse httpResponse) {
        Response repoResponse = new Response();
        try {
            httpResponse.setContentType("text/xml");
            httpResponse.getWriter().write(repoResponse.getIdentifyResponse(requestParams, this.repository));
        }
        catch (Exception e) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Internal error, could not serve request"));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private void serveListMetadataFormats(Properties requestParams, HttpServletResponse httpResponse) {
        Response repoResponse = new Response();
        try {
            httpResponse.setContentType("text/xml");
            httpResponse.getWriter().write(repoResponse.getListMetadataFormatsResponse(requestParams, this.repository));
        }
        catch (Exception e) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Internal error, could not serve request"));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private void serveListSets(Properties requestParams, HttpServletResponse httpResponse) {
        Response repoResponse = new Response();
        try {
            httpResponse.setContentType("text/xml");
            httpResponse.getWriter().write(repoResponse.getListSetsResponse(requestParams, this.repository));
        }
        catch (Exception e) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Internal error, could not serve request"));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private boolean missingIdentifiersParams(Properties requestParams) {
        if (requestParams.getProperty("set") == null) {
            return true;
        }
        if (requestParams.getProperty("metadataPrefix") == null) {
            return true;
        }
        return requestParams.getProperty("resumptionToken") == null;
    }

    private void serveListIdentifiers(Properties requestParams, HttpServletResponse httpResponse, ASLSession aslsession, int cursor, int total) throws InitialBridgingNotCompleteException, InternalErrorException, SearchASLException {
        Response repoResponse = new Response();
        String set = requestParams.getProperty("set");
        if (set == null) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Need to specify a 'set' parameter on the get request"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList<String> presentableFieldsIDs = new ArrayList<String>();
        for (Pair pair : (ArrayList)this.presentableFields.get(Tools.getIDforName((HashMap)this.collections, (String)set))) {
            presentableFieldsIDs.add(pair.getID());
        }
        aslsession.setAttribute("presentationFields", presentableFieldsIDs);
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        HashMap<String, String> values = new HashMap<String, String>();
        Query q = new Query();
        q.setBrowseBy((String)presentableFieldsIDs.get(0));
        q.selectCollections(Arrays.asList(Tools.getIDforName((HashMap)this.collections, (String)set)), true, aslsession, false);
        logger.debug("Performing the browse query...");
        ResultSetConsumerI rs = q.browse(aslsession, (ISearchClient)new SearchClientImpl());
        logger.debug("Got the result set. Starting forming the response object.");
        List digitalObjects = null;
        try {
            if (cursor == 0 || cursor < 50) {
                digitalObjects = rs.getFirst(50, new DisableButtons(), aslsession);
            } else {
                rs.advanceReaderBy(cursor);
                digitalObjects = rs.getNext(50, new DisableButtons(), aslsession);
            }
        }
        catch (gRS2AvailableRecordsRetrievalException | gRS2NoRecordReadWithinTimeIntervalException | gRS2ReaderException | gRS2RecordDefinitionException e3) {
            e3.printStackTrace();
        }
        for (DigitalObject object : digitalObjects) {
            logger.debug("adding object with id: " + object.getObjectId() + " to the response");
            values.clear();
            values.put("id", object.getObjectId());
            values.put("datestamp", Toolbox.dateTimeNow());
            Properties sets = new Properties();
            if (set != null) {
                sets.put(set, set);
            }
            Identifier identifier = new Identifier(values, sets);
            identifiers.add(identifier);
        }
        logger.debug("Writing response - serveListIdentifiers()");
        try {
            httpResponse.setContentType("text/xml");
            httpResponse.getWriter().write(repoResponse.getListIdentifiersResponse(requestParams, this.repository, identifiers, cursor, total));
        }
        catch (Exception e) {
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Internal error, could not serve request"));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private void serveListRecords(Properties requestParams, HttpServletResponse httpResponse, ASLSession aslsession, int cursor, int total) throws InitialBridgingNotCompleteException, InternalErrorException, SearchASLException {
        String metadataPrefix;
        Response repoResponse = new Response();
        String set = requestParams.getProperty("set");
        if (set == null) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Need to specify a 'set' parameter on the request"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((metadataPrefix = requestParams.getProperty("metadataPrefix")) == null) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Need to specify a 'metadataPrefix' parameter on the request"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList<String> presentableFieldsIDs = new ArrayList<String>();
        for (Pair pair : (ArrayList)this.presentableFields.get(Tools.getIDforName((HashMap)this.collections, (String)set))) {
            presentableFieldsIDs.add(pair.getID());
        }
        aslsession.setAttribute("presentationFields", presentableFieldsIDs);
        ArrayList<Record> records = new ArrayList<Record>();
        HashMap<String, String> values = new HashMap<String, String>();
        Query q = new Query();
        q.setBrowseBy((String)presentableFieldsIDs.get(0));
        q.selectCollections(Arrays.asList(Tools.getIDforName((HashMap)this.collections, (String)set)), true, aslsession, false);
        logger.debug("Performing the browse query by collection: " + set + "(" + Tools.getIDforName((HashMap)this.collections, (String)set) + ")");
        ResultSetConsumerI rs = q.browse(aslsession, (ISearchClient)new SearchClientImpl());
        logger.debug("Got the result set. Starting forming the response object.");
        List nameValuesRec = null;
        try {
            if (cursor == 0 || cursor < 50) {
                nameValuesRec = rs.getFirstRaw(50, new DisableButtons(), aslsession);
            } else {
                rs.advanceReaderBy(cursor);
                nameValuesRec = rs.getNextRaw(50, new DisableButtons(), aslsession);
            }
        }
        catch (GRS2BufferException | GRS2RecordDefinitionException | gRS2AvailableRecordsRetrievalException | gRS2NoRecordReadWithinTimeIntervalException | gRS2ReaderException e3) {
            e3.printStackTrace();
        }
        for (Properties nameValues : nameValuesRec) {
            values.clear();
            for (String key : nameValues.stringPropertyNames()) {
                values.put(key, (String)nameValues.get(key));
            }
            Properties sets = new Properties();
            if (set != null) {
                sets.put(set, set);
            }
            Record record = metadataPrefix.equalsIgnoreCase(MetadataConstants.DCNAME) && this.repository.getSupportedMetadataPrefixes().contains(MetadataConstants.DCNAME) ? new Record(values, this.repository.getRecordTemplateDC(), sets, this.repository.getOAIDCMetadataXSD()) : new Record(values, this.repository.getRecordTemplateCustom(), sets, this.repository.getCustomMetadataXSD());
            records.add(record);
        }
        logger.debug("Writing response - serveListRecords()");
        try {
            httpResponse.setContentType("text/xml");
            httpResponse.getWriter().write(repoResponse.getListRecordsResponse(requestParams, this.repository, records, cursor, total));
        }
        catch (Exception e) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Internal error, could not serve request"));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private void serveGetRecord(Properties requestParams, HttpServletResponse httpResponse, ASLSession aslsession) throws InitialBridgingNotCompleteException, InternalErrorException, SearchASLException {
        String recordID;
        String metadataPrefix;
        Response repoResponse = new Response();
        String set = requestParams.getProperty("set");
        if (set == null) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Need to specify a 'set' parameter on the request"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((metadataPrefix = requestParams.getProperty("metadataPrefix")) == null) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Need to specify a 'metadataPrefix' parameter on the request"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((recordID = requestParams.getProperty("identifier")) == null) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Need to specify an 'identifier' parameter on the request"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList<String> presentableFieldsIDs = new ArrayList<String>();
        for (Pair pair : (ArrayList)this.presentableFields.get(Tools.getIDforName((HashMap)this.collections, (String)set))) {
            presentableFieldsIDs.add(pair.getID());
        }
        aslsession.setAttribute("presentationFields", presentableFieldsIDs);
        Query q = new Query();
        q.setSearchType("advancedSearch");
        q.setSemanticEnrichment(true);
        q.selectCollections(Arrays.asList(Tools.getIDforName((HashMap)this.collections, (String)set)), true, aslsession, true);
        ArrayList id_names = (ArrayList)this.browsableFields.get(Tools.getIDforName((HashMap)this.collections, (String)set));
        String identifier = "";
        for (Pair id_name : id_names) {
            if (!id_name.getName().equalsIgnoreCase("identifier")) continue;
            identifier = id_name.getID();
            break;
        }
        logger.debug("Setting criterion: identifier(" + identifier + ")=" + recordID);
        Criterion newCrit = new Criterion();
        newCrit.setSearchFieldId(identifier);
        newCrit.setSearchFieldName("identifier");
        newCrit.setSearchFieldValue(recordID);
        q.addCriterion(newCrit);
        logger.debug("Performing the search query on collection: " + set + "(" + Tools.getIDforName((HashMap)this.collections, (String)set) + ") for objectID: " + recordID);
        List nameValuesRec = null;
        try {
            ResultSetConsumerI rs = q.search(aslsession, false, (ISearchClient)new SearchClientImpl());
            logger.debug("Got the result set. Starting forming the response object.");
            nameValuesRec = rs.getFirstRaw(2, new DisableButtons(), aslsession);
        }
        catch (GRS2BufferException | GRS2RecordDefinitionException | NoSearchMasterEPRFoundException | QuerySyntaxException | gRS2AvailableRecordsRetrievalException | gRS2NoRecordReadWithinTimeIntervalException | gRS2ReaderException e3) {
            logger.debug(e3.getLocalizedMessage());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        Properties nameValues = (Properties)nameValuesRec.get(0);
        values.clear();
        for (String key : ((Properties)nameValuesRec.get(0)).stringPropertyNames()) {
            values.put(key, (String)nameValues.get(key));
        }
        Properties sets = new Properties();
        if (set != null) {
            sets.put(set, set);
        }
        Record record = metadataPrefix.equalsIgnoreCase(MetadataConstants.DCNAME) && this.repository.getSupportedMetadataPrefixes().contains(MetadataConstants.DCNAME) ? new Record(values, this.repository.getRecordTemplateDC(), sets, this.repository.getOAIDCMetadataXSD()) : new Record(values, this.repository.getRecordTemplateCustom(), sets, this.repository.getCustomMetadataXSD());
        logger.debug("Writing response - serveGetRecord()");
        try {
            httpResponse.setContentType("text/xml");
            httpResponse.getWriter().write(repoResponse.getGetRecordResponse(requestParams, this.repository, record));
        }
        catch (Exception e) {
            httpResponse.setContentType("text/xml");
            try {
                httpResponse.getWriter().write(repoResponse.getErrorResponse(requestParams, this.repository, "Internal error, could not serve request"));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private String getStackTraceString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private void showRepoAndCollectionsInfo() throws MalformedURLException {
        try {
            this.repository = GCubeRepository.createRepository((String)this.url, (String)this.email, (HashMap)this.collections, (HashMap)this.browsableFields, (HashMap)this.presentableFields);
        }
        catch (IOException e) {
            logger.debug("Error while initiating the GCubeRepository" + e);
        }
        logger.debug("Collections: " + this.collections);
        for (String key : this.browsableFields.keySet()) {
            logger.debug("browsable fields of " + key + " : ");
            for (Pair p : (ArrayList)this.browsableFields.get(key)) {
                logger.debug("\t id: " + p.getID() + "\tname: " + p.getName());
            }
        }
        for (String key : this.presentableFields.keySet()) {
            logger.debug("presentable fields of " + key + " : ");
            for (Pair p : (ArrayList)this.presentableFields.get(key)) {
                logger.debug("\t id: " + p.getID() + "\tname: " + p.getName());
            }
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ HashMap access$102(OAI2 x0, HashMap x1) {
        x0.gCubeCollections = x1;
        return x0.gCubeCollections;
    }
}

