/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar;

import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.gcube.keycloak.avatar.AbstractAvatarResource;
import org.gcube.keycloak.avatar.AvatarAdminResource;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resources.RealmsResource;

public class AvatarResource
extends AbstractAvatarResource {
    public static final String STATE_CHECKER_ATTRIBUTE = "state_checker";
    public static final String STATE_CHECKER_PARAMETER = "stateChecker";

    public AvatarResource(KeycloakSession session) {
        super(session);
    }

    @Path(value="/admin")
    public AvatarAdminResource admin() {
        AvatarAdminResource service = new AvatarAdminResource(this.session);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        service.init();
        return service;
    }

    @GET
    @Produces(value={"image/png", "image/jpeg", "image/gif"})
    public Response downloadCurrentUserAvatarImage() {
        if (this.auth == null) {
            logger.debug((Object)"Unhautorized call to get avatar");
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        logger.debugf("Getting avatar for user %s in realm %s", (Object)this.auth.getUser(), (Object)this.auth.getSession().getRealm());
        return this.fetchAndCreateResponse(this.auth.getSession().getRealm(), this.auth.getUser());
    }

    @POST
    @NoCache
    @Consumes(value={"multipart/form-data"})
    public Response uploadCurrentUserAvatarImage(MultipartFormDataInput input, @Context UriInfo uriInfo) {
        if (this.auth == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        if (!this.isValidStateChecker(input)) {
            throw new ForbiddenException("State");
        }
        logger.debugf("Uploading new avatar for user %s in realm %s", (Object)this.auth.getUser(), (Object)this.auth.getSession().getRealm());
        try {
            InputStream imageInputStream = (InputStream)input.getFormDataPart("image", InputStream.class, null);
            this.saveUserImage(this.auth.getSession().getRealm(), this.auth.getUser(), imageInputStream);
            if (uriInfo.getQueryParameters().containsKey((Object)"account")) {
                return Response.seeOther((URI)RealmsResource.accountUrl((UriBuilder)this.session.getContext().getUri().getBaseUriBuilder()).build(new Object[]{this.auth.getSession().getRealm().getName()})).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            return Response.serverError().build();
        }
    }

    private boolean isValidStateChecker(MultipartFormDataInput input) {
        try {
            String actualStateChecker = (String)input.getFormDataPart(STATE_CHECKER_PARAMETER, String.class, null);
            String requiredStateChecker = (String)this.session.getAttribute(STATE_CHECKER_ATTRIBUTE);
            return Objects.equals(requiredStateChecker, actualStateChecker);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

