/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.client.proxy;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.gcube.common.authorization.client.Binder;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.client.proxy.AuthorizationEntryCache;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.client.proxy.Utils;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.ExternalServiceList;
import org.gcube.common.authorization.library.Policies;
import org.gcube.common.authorization.library.QualifiersList;
import org.gcube.common.authorization.library.enpoints.AuthorizationEndpoint;
import org.gcube.common.authorization.library.enpoints.AuthorizationEndpointScanner;
import org.gcube.common.authorization.library.enpoints.EndpointsContainer;
import org.gcube.common.authorization.library.policies.Policy;
import org.gcube.common.authorization.library.provider.ContainerInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.ServiceInfo;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.authorization.library.utils.AuthorizationEntryList;
import org.gcube.common.authorization.library.utils.ListMapper;
import org.gcube.common.authorization.library.utils.MultiServiceTokenRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationProxy
implements AuthorizationProxy {
    private static Logger log = LoggerFactory.getLogger(AuthorizationProxy.class);
    private static Map<String, AuthorizationEntryCache> cache = Collections.synchronizedMap(new HashMap());
    private static EndpointsContainer endpoints;

    public DefaultAuthorizationProxy() {
        if (endpoints == null) {
            endpoints = AuthorizationEndpointScanner.endpoints();
        }
    }

    private String getInternalEnpoint(int infrastructureHash) {
        AuthorizationEndpoint ae = this.getEndpoint(infrastructureHash);
        return this.getInternalEnpoint(ae);
    }

    private String getInternalEnpoint(AuthorizationEndpoint ae) {
        StringBuilder endpoint = new StringBuilder(ae.isSecureConnection() ? "https://" : "http://").append(ae.getHost()).append(":").append(ae.getPort()).append("/authorization-service/gcube/service");
        return endpoint.toString();
    }

    @Override
    public String generateServiceToken(ServiceInfo client) throws Exception {
        String methodPath = "/token/service";
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", true);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)client, (OutputStream)os);
        }
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public List<String> generateServiceToken(ServiceInfo client, List<String> containerTokens) throws Exception {
        String methodPath = "/token/service/bunch";
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", true);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)new MultiServiceTokenRequest(containerTokens, client), (OutputStream)os);
        }
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        ArrayList<String> tokensToReturn = new ArrayList<String>();
        try (InputStream stream = (InputStream)connection.getContent();){
            ListMapper entries = (ListMapper)Binder.getContext().createUnmarshaller().unmarshal(stream);
            for (String token : entries.getList()) {
                tokensToReturn.add(Utils.addInfrastructureHashToToken(token, infrastructureHash));
            }
            ArrayList<String> arrayList = tokensToReturn;
            return arrayList;
        }
    }

    @Override
    public String generateExternalServiceToken(String serviceId) throws Exception {
        String methodPath = "/token/external/";
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath).append(serviceId);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public String resolveTokenByUserAndContext(String user, String context) throws ObjectNotFound, Exception {
        String methodPath = "/token/resolve/";
        int infrastructureHash = Utils.getInfrastructureHashfromContext(context);
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath).append(user).append("?context=").append(context);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", false);
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() == 404) {
            throw new ObjectNotFound("token not found");
        }
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service (error code is " + connection.getResponseCode() + ")");
        }
        if (connection.getContentLengthLong() == 0L) {
            return null;
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public String generateUserToken(UserInfo client, String context) throws Exception {
        String methodPath = "/token/user";
        int infrastructureHash = Utils.getInfrastructureHashfromContext(context);
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath).append("?").append(Constants.CONTEXT_PARAM).append("=").append(context);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)client, (OutputStream)os);
        }
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public void setTokenRoles(String token, List<String> roles) throws Exception {
        String realToken = Utils.getRealToken(token);
        String methodPath = String.format("/token/user/%s/roles", realToken);
        int infrastructureHash = Utils.getInfrastructureHashFromToken(token, endpoints.getDefaultInfrastructure());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        ListMapper listmapper = new ListMapper(roles);
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)listmapper, (OutputStream)os);
        }
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
    }

    @Override
    public void removeAllReleatedToken(String clientId, String context) throws Exception {
        String methodPath = "/token/user";
        int infrastructureHash = Utils.getInfrastructureHashfromContext(context);
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath).append("?").append(Constants.CONTEXT_PARAM).append("=").append(context).append("&").append(Constants.CLIENT_ID_PARAM).append("=").append(clientId);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "DELETE", false);
        connection.setDoInput(true);
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200 && connection.getResponseCode() != 204) {
            throw new Exception("error contacting authorization service");
        }
    }

    @Override
    public String generateApiKey(String apiQualifier) throws Exception {
        String methodPath = String.format("/apikey?qualifier=%s", apiQualifier);
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", true);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(0);
        connection.setRequestProperty("Content-type", "application/xml");
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public Map<String, String> retrieveApiKeys() throws Exception {
        Map tokensQulifiersMap;
        String methodPath = "/apikey/";
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", true);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        if (connection.getResponseCode() != 200) {
            throw new Exception("error retrieving keys (error code is " + connection.getResponseCode() + ")");
        }
        if (connection.getContentLengthLong() == 0L) {
            return Collections.emptyMap();
        }
        InputStream stream = (InputStream)connection.getContent();
        Object object = null;
        try {
            QualifiersList qualifiersList = (QualifiersList)Binder.getContext().createUnmarshaller().unmarshal(stream);
            tokensQulifiersMap = qualifiersList.getQualifiers();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (object != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        if (tokensQulifiersMap != null && !tokensQulifiersMap.isEmpty()) {
            HashMap<String, String> toReturnMap = new HashMap<String, String>();
            for (Map.Entry entry : tokensQulifiersMap.entrySet()) {
                toReturnMap.put((String)entry.getKey(), Utils.addInfrastructureHashToToken((String)entry.getValue(), infrastructureHash));
            }
            return toReturnMap;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> retrieveExternalServiceGenerated() throws Exception {
        Map externalServiceMap;
        String methodPath = "/token/external";
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", true);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        if (connection.getResponseCode() != 200) {
            throw new Exception("error retrieving externalServices (error code is " + connection.getResponseCode() + ")");
        }
        if (connection.getContentLengthLong() == 0L) {
            return Collections.emptyMap();
        }
        InputStream stream = (InputStream)connection.getContent();
        Object object = null;
        try {
            ExternalServiceList externalServiceList = (ExternalServiceList)Binder.getContext().createUnmarshaller().unmarshal(stream);
            externalServiceMap = externalServiceList.getExternalServiceMap();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (object != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        if (externalServiceMap != null && !externalServiceMap.isEmpty()) {
            HashMap<String, String> toReturnMap = new HashMap<String, String>();
            for (Map.Entry entry : externalServiceMap.entrySet()) {
                toReturnMap.put((String)entry.getKey(), Utils.addInfrastructureHashToToken((String)entry.getValue(), infrastructureHash));
            }
            return toReturnMap;
        }
        return Collections.emptyMap();
    }

    @Override
    public String requestActivation(ContainerInfo container, String context) throws Exception {
        String methodPath = "/token/node";
        int infrastructureHash = Utils.getInfrastructureHashfromContext(context);
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath).append("?context=").append(context);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)container, (OutputStream)os);
        }
        log.debug("response code is " + connection.getResponseCode());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public String requestActivation(ContainerInfo container) throws Exception {
        String methodPath = "/token/node";
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", true);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)container, (OutputStream)os);
        }
        log.debug("response code is " + connection.getResponseCode());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public AuthorizationEntry get(String token) throws ObjectNotFound, Exception {
        String realToken = Utils.getRealToken(token);
        String maskedToken = String.format("%s********", realToken.substring(0, realToken.length() - 8));
        int infrastructureHashFromToken = Utils.getInfrastructureHashFromToken(token, endpoints.getDefaultInfrastructure());
        AuthorizationEndpoint endpoint = this.getEndpoint(infrastructureHashFromToken);
        if (cache.containsKey(realToken) && cache.get(realToken).isValid(endpoint.getClientCacheValidity())) {
            log.trace("valid entry found in cache for token {}, returning it", (Object)maskedToken);
            return cache.get(realToken).getEntry();
        }
        log.trace("invalid entry found in cache for token {}, contacting auth service", (Object)maskedToken);
        String methodPath = "/token/";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHashFromToken)).append("/token/").append(realToken);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", false);
        connection.setDoInput(true);
        if (connection.getResponseCode() == 404) {
            throw new ObjectNotFound("token " + maskedToken + " not found");
        }
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service (error code is " + connection.getResponseCode() + ")");
        }
        if (connection.getContentLengthLong() == 0L) {
            return null;
        }
        try (InputStream stream = (InputStream)connection.getContent();){
            AuthorizationEntry entry = (AuthorizationEntry)Binder.getContext().createUnmarshaller().unmarshal(stream);
            if (entry != null) {
                cache.put(realToken, new AuthorizationEntryCache(entry));
            }
            AuthorizationEntry authorizationEntry = entry;
            return authorizationEntry;
        }
    }

    @Override
    public List<AuthorizationEntry> get(List<String> tokens) throws ObjectNotFound, Exception {
        ArrayList<String> realTokens = new ArrayList<String>();
        ArrayList<AuthorizationEntry> toReturn = new ArrayList<AuthorizationEntry>();
        AuthorizationEndpoint endpoint = null;
        for (String token : tokens) {
            String realToken = Utils.getRealToken(token);
            if (cache.containsKey(realToken) && cache.get(realToken).isValid(endpoint.getClientCacheValidity())) {
                toReturn.add(cache.get(realToken).getEntry());
            } else {
                realTokens.add(realToken);
            }
            if (endpoint != null) continue;
            int infrastructureHashFromToken = Utils.getInfrastructureHashFromToken(token, endpoints.getDefaultInfrastructure());
            endpoint = this.getEndpoint(infrastructureHashFromToken);
        }
        String methodPath = "/token/resolve/?";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(endpoint)).append("/token/resolve/?");
        boolean first = true;
        for (String toAppend : realTokens) {
            if (first) {
                callUrl = callUrl.append("token=").append(toAppend);
                first = false;
                continue;
            }
            callUrl = callUrl.append("&token=").append(toAppend);
        }
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", false);
        connection.setDoInput(true);
        if (connection.getResponseCode() == 404) {
            throw new ObjectNotFound("token not found");
        }
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service (error code is " + connection.getResponseCode() + ")");
        }
        if (connection.getContentLengthLong() == 0L) {
            return null;
        }
        try (InputStream stream = (InputStream)connection.getContent();){
            AuthorizationEntryList entries = (AuthorizationEntryList)Binder.getContext().createUnmarshaller().unmarshal(stream);
            List list = entries.getEntries();
            return list;
        }
    }

    @Override
    public void addPolicies(List<Policy> policies) throws Exception {
        String methodPath = "/policyManager";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure()))).append("/policyManager");
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "POST", true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)new Policies(policies), (OutputStream)os);
        }
        if (connection.getResponseCode() != 200) {
            throw new Exception("error adding policies");
        }
    }

    @Override
    public void removePolicies(long ... ids) throws Exception {
        String methodPath = "/policyManager/";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure()))).append("/policyManager/");
        ArrayList<Long> errorIds = new ArrayList<Long>();
        for (long id : ids) {
            URL url = new URL(callUrl.toString() + id);
            HttpURLConnection connection = this.makeRequest(url, "DELETE", true);
            if (connection.getResponseCode() == 200) continue;
            errorIds.add(id);
        }
        if (!errorIds.isEmpty()) {
            throw new Exception("error removing policies with ids: " + errorIds);
        }
    }

    @Override
    public List<Policy> getPolicies(String context) throws Exception {
        String methodPath = "/policyManager/";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(Utils.getInfrastructureHashfromContext(context))).append("/policyManager/").append("?").append(Constants.CONTEXT_PARAM).append("=").append(context);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", true);
        connection.setDoInput(true);
        if (connection.getResponseCode() != 200) {
            log.info("response code is not 200");
            throw new Exception("error retrieving policies");
        }
        if (connection.getContentLengthLong() == 0L) {
            return Collections.emptyList();
        }
        try (InputStreamReader stream = new InputStreamReader((InputStream)connection.getContent());){
            Policies policies = (Policies)Binder.getContext().createUnmarshaller().unmarshal((Reader)stream);
            List list = policies.getPolicies();
            return list;
        }
    }

    @Override
    public File getSymmKey(String filePath) throws Exception {
        String methodPath = "/symmKey/";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get(), endpoints.getDefaultInfrastructure()))).append("/symmKey/");
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", true);
        connection.setDoInput(true);
        if (connection.getResponseCode() != 200) {
            throw new Exception("error retrieving key");
        }
        if (connection.getContentLengthLong() <= 0L) {
            return null;
        }
        String resourceName = connection.getHeaderField("resource-name");
        File toReturnFile = new File(filePath + "/" + resourceName);
        toReturnFile.createNewFile();
        try (InputStream stream = (InputStream)connection.getContent();
             FileOutputStream os = new FileOutputStream(toReturnFile);){
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = stream.read(bytes)) != -1) {
                ((OutputStream)os).write(bytes, 0, read);
            }
        }
        return toReturnFile;
    }

    private HttpURLConnection makeRequest(URL url, String method, boolean includeTokenInHeader) throws Exception {
        HttpURLConnection connection = url.toString().startsWith("https://") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
        if (includeTokenInHeader) {
            if (SecurityTokenProvider.instance.get() == null) {
                throw new RuntimeException("null token passed");
            }
            connection.setRequestProperty("gcube-token", Utils.getRealToken(SecurityTokenProvider.instance.get()));
        }
        connection.setRequestMethod(method);
        return connection;
    }

    @Override
    public AuthorizationEndpoint getEndpoint(int infrastructureHash) {
        for (String infra : endpoints.getEndpoints().keySet()) {
            if (Utils.getInfrastructureHashfromContext(infra) != infrastructureHash) continue;
            return (AuthorizationEndpoint)endpoints.getEndpoints().get(infra);
        }
        throw new RuntimeException("Authorization Endpoint not found for the required infrastructure");
    }

    @Override
    public void setEndpoint(EndpointsContainer newEndpoints) {
        endpoints = newEndpoints;
    }
}

