/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.persistence.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.gcube.common.authorization.library.policies.Action;
import org.gcube.common.authorization.library.policies.ServiceAccess;
import org.gcube.common.authorization.library.policies.ServiceEntity;
import org.gcube.common.authorization.library.policies.Services;
import org.gcube.common.authorizationservice.persistence.entities.ExcludeType;
import org.gcube.common.authorizationservice.persistence.entities.PolicyEntity;
import org.gcube.common.authorizationservice.persistence.entities.ServicePolicyEntity;

@Entity
@DiscriminatorValue(value="ServicePolicy")
@NamedQueries(value={@NamedQuery(name="ServicePolicy.get", query="SELECT DISTINCT p FROM ServicePolicyEntity p LEFT JOIN FETCH p.excludes ae WHERE   p.context=:context AND (( p.excludeType=org.gcube.common.authorizationservice.persistence.entities.ExcludeType.NOTEXCLUDE  AND (( p.clientAccessEntity.clientServiceClass = null AND p.clientAccessEntity.clientServiceName=null AND p.clientAccessEntity.clientServiceIdentifier=null) OR ( p.clientAccessEntity.clientServiceClass = :serviceClass AND p.clientAccessEntity.clientServiceName=null AND p.clientAccessEntity.clientServiceIdentifier=null) OR ( p.clientAccessEntity.clientServiceClass = :serviceClass AND p.clientAccessEntity.clientServiceName=:serviceName AND p.clientAccessEntity.clientServiceIdentifier=null) OR ( p.clientAccessEntity.clientServiceClass = :serviceClass AND p.clientAccessEntity.clientServiceName=:serviceName AND p.clientAccessEntity.clientServiceIdentifier=:identifier))) OR ( p.excludeType=org.gcube.common.authorizationservice.persistence.entities.ExcludeType.EXCLUDE  AND NOT(( ae.clientServiceClass = null AND ae.clientServiceName=null AND ae.clientServiceIdentifier=null) OR ( ae.clientServiceClass = :serviceClass AND ae.clientServiceName=null AND ae.clientServiceIdentifier=null) OR ( ae.clientServiceClass = :serviceClass AND ae.clientServiceName=:serviceName AND ae.clientServiceIdentifier=null) OR ( ae.clientServiceClass = :serviceClass AND ae.clientServiceName=:serviceName AND ae.clientServiceIdentifier=:identifier))))")})
public class ServicePolicyEntity
extends PolicyEntity {
    @Embedded
    ServiceAccessEntity clientAccessEntity = null;
    @ElementCollection
    private List<ServiceAccessEntity> excludes;

    protected ServicePolicyEntity() {
    }

    public ServicePolicyEntity(String context, ServiceAccess serviceAccess, ServiceEntity serviceEntityClient, Action mode) {
        super(context, serviceAccess, "ServicePolicy", mode);
        if (serviceEntityClient.getService() != null) {
            ServiceAccess clientAccess = serviceEntityClient.getService();
            this.clientAccessEntity = new ServiceAccessEntity();
            this.clientAccessEntity.clientServiceClass = clientAccess.getServiceClass();
            this.clientAccessEntity.clientServiceName = clientAccess.getName();
            this.clientAccessEntity.clientServiceIdentifier = clientAccess.getServiceId();
            this.excludeType = ExcludeType.NOTEXCLUDE;
        } else {
            this.excludes = new ArrayList();
            for (ServiceAccess sa : serviceEntityClient.getExcludes()) {
                ServiceAccessEntity sae = new ServiceAccessEntity();
                sae.clientServiceClass = sa.getServiceClass();
                sae.clientServiceName = sa.getName();
                sae.clientServiceIdentifier = sa.getServiceId();
                this.excludes.add(sae);
            }
            this.excludeType = ExcludeType.EXCLUDE;
        }
    }

    public ServiceEntity getClientAccess() {
        if (this.excludes != null && !this.excludes.isEmpty()) {
            ServiceAccess[] services = new ServiceAccess[this.excludes.size()];
            for (int i = 0; i < this.excludes.size(); ++i) {
                services[i] = new ServiceAccess(((ServiceAccessEntity)this.excludes.get((int)i)).clientServiceName, ((ServiceAccessEntity)this.excludes.get((int)i)).clientServiceClass, ((ServiceAccessEntity)this.excludes.get((int)i)).clientServiceIdentifier);
            }
            return Services.allExcept((ServiceAccess[])services);
        }
        return Services.specialized((ServiceAccess)new ServiceAccess(this.clientAccessEntity.clientServiceName, this.clientAccessEntity.clientServiceClass, this.clientAccessEntity.clientServiceIdentifier));
    }

    public boolean isRewritable() {
        return true;
    }

    public String toString() {
        return "ServicePolicyEntity [clientAccessEntity=" + this.clientAccessEntity + ", excludes=" + this.excludes + "]";
    }
}

