/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.persistence.entities;

import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQuery;
import javax.persistence.Transient;
import org.gcube.common.authorization.library.policies.Action;
import org.gcube.common.authorization.library.policies.Roles;
import org.gcube.common.authorization.library.policies.ServiceAccess;
import org.gcube.common.authorization.library.policies.UserEntity;
import org.gcube.common.authorization.library.policies.Users;
import org.gcube.common.authorizationservice.persistence.entities.ExcludeType;
import org.gcube.common.authorizationservice.persistence.entities.PolicyEntity;

@Entity
@DiscriminatorValue(value="UserPolicy")
@NamedQuery(name="UserPolicy.get", query="SELECT policy FROM UserPolicyEntity policy WHERE   policy.context=:context AND (( policy.type=org.gcube.common.authorization.library.policies.UserEntity$UserEntityType.ROLE AND policy.identifier in :rolesList) OR (policy.type=org.gcube.common.authorization.library.policies.UserEntity$UserEntityType.USER AND policy.identifier=:user ) OR  ( policy.type=org.gcube.common.authorization.library.policies.UserEntity$UserEntityType.ROLE AND policy.excludes not in :rolesList) OR (policy.type=org.gcube.common.authorization.library.policies.UserEntity$UserEntityType.USER AND :user not in (policy.excludes)))")
public class UserPolicyEntity
extends PolicyEntity {
    @Transient
    private UserEntity userClient;
    @Column(nullable=true)
    @Enumerated(value=EnumType.ORDINAL)
    private UserEntity.UserEntityType type;
    @ElementCollection
    private List<String> excludes;
    @Column(nullable=true)
    private String identifier;

    protected UserPolicyEntity() {
    }

    public UserPolicyEntity(String context, ServiceAccess serviceAccess, UserEntity user, Action action) {
        super(context, serviceAccess, "UserPolicy", action);
        this.userClient = user;
        this.type = user.getType();
        if (user.getIdentifier() != null) {
            this.identifier = user.getIdentifier();
            this.excludeType = ExcludeType.NOTEXCLUDE;
        } else {
            this.excludes = user.getExcludes();
            this.excludeType = ExcludeType.EXCLUDE;
        }
    }

    public UserEntity getUser() {
        if (this.type == UserEntity.UserEntityType.USER) {
            if (this.excludeType == ExcludeType.NOTEXCLUDE) {
                return Users.one((String)this.identifier);
            }
            return Users.allExcept((String[])this.excludes.toArray(new String[this.excludes.size()]));
        }
        if (this.excludeType == ExcludeType.NOTEXCLUDE) {
            return Roles.one((String)this.identifier);
        }
        return Roles.allExcept((String[])this.excludes.toArray(new String[this.excludes.size()]));
    }

    public boolean isRewritable() {
        return this.type == UserEntity.UserEntityType.ROLE;
    }

    public String toString() {
        return "UserPolicyEntity [identifier=" + this.identifier + ", toString()=" + super.toString() + "]";
    }
}

