/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.clientid;

import org.gcube.common.authorization.utils.clientid.RenewalProvider;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;

public class ClienIDManager
implements RenewalProvider {
    protected final String clientID;
    protected final String clientSecret;

    public ClienIDManager(String clientID, String clientSecret) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
    }

    public Secret getSecret() throws Exception {
        TokenResponse tokenResponse = KeycloakClientFactory.newInstance().queryUMAToken(this.clientID, this.clientSecret, null);
        JWTSecret jwtSecret = new JWTSecret(tokenResponse.getAccessToken());
        jwtSecret.setRenewalProvider(this);
        jwtSecret.setTokenResponse(tokenResponse);
        return jwtSecret;
    }

    public Secret getSecret(String context) throws Exception {
        TokenResponse tokenResponse = KeycloakClientFactory.newInstance().queryUMAToken(this.clientID, this.clientSecret, context, null);
        JWTSecret jwtSecret = new JWTSecret(tokenResponse.getAccessToken());
        jwtSecret.setRenewalProvider(this);
        jwtSecret.setTokenResponse(tokenResponse);
        return jwtSecret;
    }

    public Secret getOIDCSecret() throws KeycloakClientException {
        TokenResponse tokenResponse = KeycloakClientFactory.newInstance().queryOIDCToken(this.clientID, this.clientSecret);
        JWTSecret jwtSecret = new JWTSecret(tokenResponse.getAccessToken());
        jwtSecret.setRenewalProvider(this);
        jwtSecret.setTokenResponse(tokenResponse);
        return jwtSecret;
    }

    @Override
    public Secret renew() throws Exception {
        return this.getSecret();
    }
}

